 /*
  * Khoros: $Id: vtilt.c,v 1.2 1991/07/15 05:57:02 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vtilt.c,v 1.2 1991/07/15 05:57:02 khoros Exp $";
#endif

 /*
  * $Log: vtilt.c,v $
 * Revision 1.2  1991/07/15  05:57:02  khoros
 * HellPatch1
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vtilt.c
 >>>>
 >>>>      Program Name: vtilt
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Adds a specified plane to the input image to correct  for  a
 >>>>	tilt in the image luminance.
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson, Donna Koechner
 >>>>
 >>>> Date Last Updated: Fri Jun 28 16:56:45 1991
 >>>>
 >>>>          Routines: main- the main program for vtilt
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vtilt.h"


/****************************************************************
 *
 * Routine Name:  main program for vtilt
 *
 *       Input:  
 *       -i  input image 
 *       -o  resulting output image 
 *
 *
 *       [-m] tilt operation masking image
 *       [-x] specifies the slope in the X direction 
 *       [-y] specifies the slope in the Y direction 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *img2, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */

if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

img1 = readimage(vtilt->i_file);
if (img1 == NULL) exit(1);    /* Quit if bad image */
if (vtilt->m_flag) img2 = readimage(vtilt->m_file);
if (vtilt->m_flag && (img2 == NULL)) exit(1);         /* Quit if bad image */

CHECKINPUT(program,img1);       /* Verify input image */

if(vtilt->m_flag){
  MATCHINPUT(program,img1,img2);        /* Verify input images */
}

/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvtilt(img1,img2,vtilt->m_flag,vtilt->x_float,vtilt->y_float) )
{
  (void) fprintf(stderr, "lvtilt Failed\n");
  exit(1);
}

/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vtilt->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vtilt 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vtilt :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tAdds a specified plane to the input image to correct  for  a\n");
	fprintf(stderr, "\ttilt in the image luminance.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  tilt operation masking image (infile) [null]\n");
	fprintf(stderr,"\t[-x]  specifies the slope in the X direction (float) [0]\n");
	fprintf(stderr,"\t[-y]  specifies the slope in the Y direction (float) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vtilt\n");
	fprintf(stderr, "\t[-U] Gives the usage for vtilt\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vtilt.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vtilt.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vtilt
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) tilt operation masking image \n        {infile}: "; 
char	*x_pstr = 
	"\nEnter: (x) specifies the slope in the X direction \n        {float [0.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) specifies the slope in the Y direction \n        {float [0.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vtilt", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vtilt.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vtilt: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vtilt.ans");
		}

	     }

	}

	/*
	 * allocate the vtilt structure
	 */
	vtilt = (vtilt_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vtilt_struct));

	/*
	 * get required arguments for vtilt
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vtilt->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vtilt->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vtilt->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vtilt->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vtilt->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vtilt->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vtilt->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vtilt->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vtilt->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vtilt->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vtilt
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vtilt->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vtilt->m_file))
;

	vtilt->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vtilt->x_float),
	0.000000, 0.000000, 0.000000);

	vtilt->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vtilt->y_float),
	0.000000, 0.000000, 0.000000);


}



