 /*
  * Khoros: $Id: lmlse.c,v 1.4 1992/03/20 23:46:57 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lmlse.c,v 1.4 1992/03/20 23:46:57 dkhoros Exp $";
#endif

 /*
  * $Log: lmlse.c,v $
 * Revision 1.4  1992/03/20  23:46:57  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lmlse.c
 >>>>
 >>>>      Program Name: mlse
 >>>>
 >>>> Date Last Updated: Tue Feb 25 00:52:03 1992 
 >>>>
 >>>>          Routines: lmlse - the library call for mlse
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#define CLEANUP \
    {  /* cleanup workspace before leaving */ \
       if(amatrix!=NULL)free(amatrix); \
       if(bvector!=NULL)free(bvector); \
       if(zvector!=NULL)free(zvector); \
       if(ipvt!=NULL)free(ipvt); \
    } /* end of cleanup code */

typedef struct complex {
  double re,im;
} complex;
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lmlse - library call for mlse
*
* Purpose:
*    
*    solves a system of linear silseaneous equations
*    
*    

* Input:
*    
*    image          real or complex coefficient image.
*    
*    bimage         real or complex b-vector image.
*    
*    

* Output:
*    
*    image          complex vector image containing solution to simul-
*                   taneous equations.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Jeremy Worley, Salah Al-Daragmi, Johnny Pino, Matt Lawrence, Ken Downs
*    
*    Jeremy Worley Tue Feb 25 00:50:42 MST 1992
*              rows and cols explicitly declared in llse() and certain
*              functions explicitly declared in lmlse().
*    
*    

****************************************************************/


/* -library_def */
int lmlse(image,bimage)
  struct xvimage *bimage, *image;
/* -library_def_end */

/* -library_code */
{
  int i,rows1,cols1,rows2,cols2,bands,type;
  double *mat,*m1,*m2;
  char *program = "lmlse";
  struct xvimage *images[2];
  int proper_num_images(),match_num_bands(),lvcast(),llse();

  images[0] = image;
  images[1] = bimage;

  rows1 = (int)image->col_size;
  cols1 = (int)image->row_size;
  rows2 = (int)bimage->col_size;
  cols2 = (int)bimage->row_size;

/*
** check some stuff out
*/

  if(rows2!=cols1 || cols2!=1){
     fprintf(stderr,"%s:  improper dimension on b-vector.\n",program);
     return(0);
  }

  if(!proper_num_images(program,image,1,FALSE)){
     fprintf(stderr,"%s:  1 image structures should have only one image.\n",
         program);
     return(0);
  }

  if(!proper_num_images(program,bimage,1,FALSE)){
     fprintf(stderr,"%s:  2 image structures should have only one image.\n",
         program);
     return(0);
  }

  if(!match_num_bands(program,image,bimage,FALSE)){
     fprintf(stderr,"%s:  images structures must have same number of bands.\n",
         program);
     return(0);
  }

  bands = image->num_data_bands;

/*
** cast all of the data up to double or double complex
*/

   if(image->data_storage_type==VFF_TYP_COMPLEX || image->data_storage_type==
        VFF_TYP_DCOMPLEX || bimage->data_storage_type==VFF_TYP_COMPLEX ||
        bimage->data_storage_type==VFF_TYP_DCOMPLEX){
      if(!lvcast(images,(int)2,(int)VFF_TYP_DCOMPLEX)){
         fprintf(stderr,"%s:  Failure to cast up to double complex.\n",program);
         return(0);
      }
      type = 1;
   }else{
      if(!lvcast(images,(int)2,(int)VFF_TYP_DOUBLE)){
         fprintf(stderr,"%s:  Failure to cast up to double.\n",program);
         return(0);
      }
      type = 0;
   }

   if((mat=(double *)malloc((type+1)*bands*rows1*sizeof(double)))==NULL){
      fprintf(stderr,"%s:  failure to malloc.\n",program);
      return(0);
   }

/*
** process all of the data
*/

   m1 = (double *)(image->imagedata);
   m2 = (double *)(bimage->imagedata);

   for(i=0;i<bands;i++){
      if(!llse(&mat[rows1*i],m1,m2,rows1,cols1,type,type)){
         fprintf(stderr,"%s:  Failed call to static routine.\n",program);
         free((char *)mat);
         return(0);
      }

      m1 += (type+1)*rows1*cols1;
      m2 += (type+1)*rows2*cols2;
   }

   image->imagedata = (char *)mat;
   image->row_size = cols2;
   image->col_size = rows1;

   return(1);
}

/***********************************************************************
*
*  Routine Name: llse
*
*          Date:
*        
*       Purpose:  
*
*         Input: 
*
*        Output: 
*
*    Written By:  
*
* Modifications:
*
***********************************************************************/

int llse(xvector,matrix,bvect,rows,cols,typea,typeb)
  double *xvector, *bvect, *matrix;
  int typea,typeb,rows,cols;
{
  int   index1,index2,k,j;
  void zgesl_(), zgeco_();
  void swap();

  complex *amatrix,*bvector=NULL,*zvector=NULL;
  int *ipvt=NULL,zero=0;
  double rcond;

  char *program = "lmlse";

/*
** allocate memory for junk
*/

  amatrix = (complex *)malloc((unsigned)rows * cols * sizeof(complex));
  if(amatrix==NULL){
     fprintf(stderr,"%s:  [1]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  bvector = (complex *)malloc((unsigned)cols * sizeof(complex));
  if(bvector==NULL){
     fprintf(stderr,"%s:  [2]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  zvector = (complex *)malloc((unsigned)cols * sizeof(complex));
  if(zvector==NULL){
     fprintf(stderr,"%s:  [3]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  ipvt = (int *)malloc((unsigned)cols * sizeof(int));
  if(ipvt==NULL){
     fprintf(stderr,"%s:  [4]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

/*
** transpose data 'cause were working with that brain-dead excuse for
** a language FORTRAN... 
*/

  if(typea == 0){
     for(j=0;j<rows;j++){
         for(k=0;k<cols;k++){
            amatrix[j*cols+k].re = matrix[j+k*cols];
            amatrix[j*cols+k].im = 0.0;
         }
     }
  }else{
     for(j=0;j<rows;j++){
         for(k=0;k<cols;k++){
            index1 = j*cols + k;
            index2 = j + k*cols ;
            amatrix[index1].re = matrix[2*index2];
            amatrix[index1].im = matrix[2*index2 + 1];
         }
     }
  }

  if(typeb == 0){
     for(j=0;j<cols;j++){
         bvector[j].re = bvect[j];
         bvector[j].im = 0.0;
     }
  }else{
     for(j=0;j<cols;j++){
         index1 = 2*j;
         bvector[j].re = bvect[index1];
         bvector[j].im = bvect[index1+1];
     }
  }

/*
** zgeco factors a complex*16 matrix by gaussian elimination
** and estimates the condition of the matrix.
*/

  (void)zgeco_(amatrix,&rows,&cols,ipvt,&rcond,zvector);

/*
** if the condition of the matrix is less than zero, then zgesl won't
** function properly.
*/

  if(rcond<=0.0){
     (void)fprintf(stderr,"%s:  condition of matrix less than 0.\n",
           program);
     return(0);
  }

/*
** zgesl solves the complex*16 system
** a * x = b using the factors computed by zgeco
*/

  (void)zgesl_(amatrix,&rows,&cols,ipvt,bvector,&zero);

/*
** copy the data to xvector and get the hell outa here....
*/

  if(typea==1 || typeb==1){
     for(k=0;k<cols;k++){
         index1 = 2*k;
         xvector[index1] = bvector[k].re;
         xvector[index1+1] = bvector[k].im;
     }
  }else{
     for(k=0;k<cols;k++){
         xvector[k] = bvector[k].re;
     }
  }

  return(1);
}
/* -library_code_end */
