 /*
  * Khoros: $Id: viff2mat.h,v 1.3 1992/03/20 23:36:30 dkhoros Exp $
  */

 /*
  * $Log: viff2mat.h,v $
 * Revision 1.3  1992/03/20  23:36:30  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viff2mat.h
 >>>>            Author: Matthew Lawrence,Jeremy Worley
 >>>> Date Last Updated: Thu Mar 19 17:41:54 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _viff2mat_h_
#define _viff2mat_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    viff2mat Argument Structure
*
****************************************************************/

typedef struct _viff2mat  {

/*
 *  input file (image file) (Required infile)
 */
char	*i_file;	/* input file (image file) FILENAME */
int	 i_flag;	/* input file (image file) FLAG */

/*
 *  resulting output file (matrix file) (Required outfile)
 */
char	*o_file;	/* resulting output file (matrix file) FILENAME */
int	 o_flag;	/* resulting output file (matrix file) FLAG */

/*
 *  number of elements per line (Optional integer)
 */
int	 e_int; 	/* number of elements per line INT */
int	 e_flag;	/* number of elements per line FLAG */

/*
 *  field size (Optional integer)
 */
int	 s_int; 	/* field size INT */
int	 s_flag;	/* field size FLAG */

/*
 *  number of fractional digits (Optional integer)
 */
int	 m_int; 	/* number of fractional digits INT */
int	 m_flag;	/* number of fractional digits FLAG */

/*
 *  justification (0 = right, 1 = left) (Optional logical)
 */
int	 j_logic;	/* justification (0 = right, 1 = left) LOGIC */
int	 j_flag;  	/* justification (0 = right, 1 = left) FLAG */

/*
 *  bracket type (0 = square, 1 = triangular) (Optional logical)
 */
int	 b_logic;	/* bracket type (0 = square, 1 = triangular) LOGIC */
int	 b_flag;  	/* bracket type (0 = square, 1 = triangular) FLAG */

/*
 *  element delimiter (0 = space, 1 = comma) (Optional logical)
 */
int	 d_logic;	/* element delimiter (0 = space, 1 = comma) LOGIC */
int	 d_flag;  	/* element delimiter (0 = space, 1 = comma) FLAG */

/*
 * element format(0 - integer, 1 - floating point, 2 - scientific notation (Optional integer toggle - )
 */
int	 f_toggle;		/* element format(0 - integer, 1 - floating point, 2 - scientific notation INT TOGGLE */
int	 f_flag;		/* element format(0 - integer, 1 - floating point, 2 - scientific notation FLAG */

}  viff2mat_struct;

viff2mat_struct *viff2mat;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
