 /*
  * Khoros: $Id: darpsd.c,v 1.2 1992/03/20 23:15:30 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: darpsd.c,v 1.2 1992/03/20 23:15:30 dkhoros Exp $";
#endif

 /*
  * $Log: darpsd.c,v $
 * Revision 1.2  1992/03/20  23:15:30  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: darpsd.c
 >>>>
 >>>>      Program Name: darpsd
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	1D Autoregressive (AR) PSD
 >>>>	
 >>>>	

 >>>>            Author: Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:55:09 1992
 >>>>
 >>>>          Routines: main- the main program for darpsd
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "darpsd.h"


/****************************************************************
 *
 * Routine Name:  main program for darpsd
 *
 *       Input:  
 *        -i  input file (xviff file) 
 *        -o  resulting output file (xviff file) 
 *
 *
 *        [-n] number of points for PSD estimate  (value > 0)
 *        [-t] AR coefficients from Lattice filter(1) or TAPPED filter(0) (default)
 *        [-p] Phase estimate(0) or PSD estimate(1) (default)
 *        [-y] do NOT normalize (0) or YES normalize(1) (default)
 *        [-d] down vectors(0) or across bands(1) (default)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
int     nfreq, arfrom, estimate, normalize, procdir;
char    *malloc();

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
READIMAGE(image);
CHECKTYPE(program,image);
CHECKTYPE(program,image);

nfreq = darpsd->n_int;
arfrom = darpsd->t_logic;
estimate = darpsd->p_logic;
normalize = darpsd->y_logic;
procdir = darpsd->d_logic;

/* -main_before_lib_call_end */

/* -main_library_call */

if(! ldarpsd ( image, nfreq, arfrom, estimate, normalize, procdir ) )
        {
            (void) fprintf(stderr, "ldarpsd Failed\n");
            exit(1);
        }

/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(darpsd->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for darpsd 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "darpsd :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t1D Autoregressive (AR) PSD\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"t\" AR coefficients from:\n");
(void) fprintf(stderr,"\t\"t=0\" Tapped delay (default)\n\n");
(void) fprintf(stderr,"\t\"t=1\" Lattice filter\n");
(void) fprintf(stderr,"where \"p\" PSD or Phase spectra:\n");
(void) fprintf(stderr,"\t\"p=0\" Phase spectral estimate\n");
(void) fprintf(stderr,"\t\"p=1\" PSD estimate(default)\n\n");
(void) fprintf(stderr,"where \"y\" normalize PSD estimate:\n");
(void) fprintf(stderr,"\t\"y=0\" do NOT normalize\n");
(void) fprintf(stderr,"\t\"y=1\" YES normalize (default)\n\n");
(void) fprintf(stderr,"where \"d\" direction of processing:\n");
(void) fprintf(stderr,"\t\"d=0\" down vectors \n");
(void) fprintf(stderr,"\t\"d=1\" across bands (default)\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-n]  number of points for PSD estimate (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-t]  AR coefficients from Lattice filter(1) or TAPPED filter(0) (default) (boolean) [false]\n");
	fprintf(stderr,"\t[-p]  Phase estimate(0) or PSD estimate(1) (default) (boolean) [true]\n");
	fprintf(stderr,"\t[-y]  do NOT normalize (0) or YES normalize(1) (default) (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  down vectors(0) or across bands(1) (default) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for darpsd\n");
	fprintf(stderr, "\t[-U] Gives the usage for darpsd\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called darpsd.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses darpsd.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for darpsd
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) number of points for PSD estimate \n        {integer, > 0 [1] }: "; 
char	*t_pstr = 
	"\nEnter: (t) AR coefficients from Lattice filter(1) or TAPPED filter(0) (default) \n        {boolean, (y/n)  [no] }: "; 
char	*p_pstr = 
	"\nEnter: (p) Phase estimate(0) or PSD estimate(1) (default) \n        {boolean, (y/n)  [yes] }: "; 
char	*y_pstr = 
	"\nEnter: (y) do NOT normalize (0) or YES normalize(1) (default) \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) down vectors(0) or across bands(1) (default) \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "darpsd", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "darpsd.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "darpsd: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "darpsd.ans");
		}

	     }

	}

	/*
	 * allocate the darpsd structure
	 */
	darpsd = (darpsd_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (darpsd_struct));

	/*
	 * get required arguments for darpsd
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(darpsd->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(darpsd->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(darpsd->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    darpsd->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(darpsd->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(darpsd->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(darpsd->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(darpsd->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    darpsd->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(darpsd->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for darpsd
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	darpsd->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(darpsd->n_int),
	1, 2, 2);

	darpsd->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(darpsd->t_logic), 0);

	darpsd->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(darpsd->p_logic), 1);

	darpsd->y_flag = vget_logic(fid, prompt_flag,
	"-y", y_pstr, &(darpsd->y_logic), 1);

	darpsd->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(darpsd->d_logic), 1);


}



