 /*
  * Khoros: $Id: dshift.h,v 1.2 1992/03/20 23:32:54 dkhoros Exp $
  */

 /*
  * $Log: dshift.h,v $
 * Revision 1.2  1992/03/20  23:32:54  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dshift.h
 >>>>            Author: Donna Koechner
 >>>> Date Last Updated: Sat Feb 15 16:36:20 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dshift_h_
#define _dshift_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dshift Argument Structure
*
****************************************************************/

typedef struct _dshift  {

/*
 *  input data file (Required infile)
 */
char	*i_file;	/* input data file FILENAME */
int	 i_flag;	/* input data file FLAG */

/*
 *  resulting output file (Required outfile)
 */
char	*o_file;	/* resulting output file FILENAME */
int	 o_flag;	/* resulting output file FLAG */

/*
 *  Real Padding Value (Optional float)
 */
float	 j_float;	/* Real Padding Value FLOAT */
int	 j_flag;   	/* Real Padding Value FLAG */

/*
 *  Imaginary Padding Value (Optional float)
 */
float	 k_float;	/* Imaginary Padding Value FLOAT */
int	 k_flag;   	/* Imaginary Padding Value FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*
 * Shift or Rotate (wrap). Rotate: w=1, Shift: w=0 (default=0) (Optional integer toggle - )
 */
int	 w_toggle;		/* Shift or Rotate (wrap). Rotate: w=1, Shift: w=0 (default=0) INT TOGGLE */
int	 w_flag;		/* Shift or Rotate (wrap). Rotate: w=1, Shift: w=0 (default=0) FLAG */

/*----  these are an Optional mutually exclusive group ----*/
/*
 *  Positive or Negative Shifting value (Required integer)
 */
int	 x_int; 	/* Positive or Negative Shifting value INT */
int	 x_flag;	/* Positive or Negative Shifting value FLAG */

/*
 *  Input Shifting Value File (Required infile)
 */
char	*i2_file;	/* Input Shifting Value File FILENAME */
int	 i2_flag;	/* Input Shifting Value File FLAG */

/*-------------------------------------------*/

}  dshift_struct;

dshift_struct *dshift;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(dshift->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"dshift: Image could not be read\n"); \
        exit(1); \
    }

#define CHECKTYPE(program, image) \
    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) ) { \
          fprintf(stderr,"dshift: data storage type must be float or complex.\n"); \
          exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_dim(program,image,0,TRUE); \
        \
        (void) proper_loc_type(program,image,VFF_LOC_IMPLICIT,TRUE)
/* -include_macros_end */

#endif
