 /*
  * Khoros: $Id: dgwindow.c,v 1.3 1992/03/20 23:17:37 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dgwindow.c,v 1.3 1992/03/20 23:17:37 dkhoros Exp $";
#endif

 /*
  * $Log: dgwindow.c,v $
 * Revision 1.3  1992/03/20  23:17:37  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dgwindow.c
 >>>>
 >>>>      Program Name: dgwindow
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	1D Window Creation.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar  5 12:02:14 1992
 >>>>
 >>>>          Routines: main- the main program for dgwindow
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dgwindow.h"


/****************************************************************
 *
 * Routine Name:  main program for dgwindow
 *
 *       Input:  
 *          -o  resulting output file (xviff file) 
 *
 *
 *          [-trigger] trigger input
 *          [-s] number of signals to generate 
 *          [-p] number of elements per signal 
 *          [-k] desired THETA parameter for Kaiser window 
 *          [-e] desired damping parameter for Exponential window  (value >= 0.0)
 *          [-b] desired window width for User defined window  (value >= 0)
 *          [-d] data processing direction (0 = down vectors, 1 = across bands)
 *          [-w] windowed output file to be created
 *		0 (selection of Rectangular window ),
 *		1 (selection of Bartlett window ),
 *		2 (selection of Hamming window),
 *		3 (selection of Hanning window),
 *		4 (selection of Parzen window),
 *		5 (selection of Kaiser window),
 *		6 (selection of Exponential window),
 *		7 (selection of Blackman window),
 *		8 (selection of Blackman-Harris window),
 *		9 (selection of Right-Triangular window),
 *		10 (selection of Left-Triangular window),
 *		11 (selection of Right-Exponential window),
 *		12 (selection of Left-Exponential window),
 *		or 13 (selection of Left-Triangular window)
 *		   [default = 0] 
 *          [-t] lets user choose data type of image
 *		'float' (select data type),
 *		 or 'complex' (choose data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image=NULL;
int    window_option, width, nsig, nelem, procdir,type;
float  theta, damp;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

theta = dgwindow->k_float;
damp = dgwindow->e_float;
width = dgwindow->b_int;
window_option = dgwindow->w_toggle;
procdir = dgwindow->d_logic;
nsig = dgwindow->s_int;
nelem = dgwindow->p_int;

  if(!vget_type(&type,dgwindow->t_toggle)){
     fprintf(stderr,"dgwindow:  Invalid data type specified\n");
     exit(1);
  }
/* -main_before_lib_call_end */

/* -main_library_call */
if(! ldgwindow (&image,type,window_option,nsig,nelem,theta,damp,width,procdir)){
    (void) fprintf(stderr, "ldgwindow Failed\n");
    exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(dgwindow->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dgwindow 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dgwindow :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t1D Window Creation.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"w\" is the window to be created:\n");
(void) fprintf(stderr,"\t\"w=0\" Rectangular window\n");
(void) fprintf(stderr,"\t\"w=1\" Bartlett window\n");
(void) fprintf(stderr,"\t\"w=2\" Hamming window\n");
(void) fprintf(stderr,"\t\"w=3\" Hanning window\n");
(void) fprintf(stderr,"\t\"w=4\" Parzen window\n");
(void) fprintf(stderr,"\t\"w=5\" Kaiser window\n");
(void) fprintf(stderr,"\t\"w=6\" Exponential window\n");
(void) fprintf(stderr,"\t\"w=7\" Blackman window\n");
(void) fprintf(stderr,"\t\"w=8\" Blackman-Harris window\n");
(void) fprintf(stderr,"\t\"w=9\" Right-Triangular window\n");
(void) fprintf(stderr,"\t\"w=10\" Left-Triangular window\n");
(void) fprintf(stderr,"\t\"w=11\" Right-Exponential window\n");
(void) fprintf(stderr,"\t\"w=12\" Left-Exponential window\n");
(void) fprintf(stderr,"\t\"w=13\" User Defined Triangular window\n");
(void) fprintf(stderr,"\n\t-t may be followed by either float or complex.\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-s]  number of signals to generate (integer) [1]\n");
	fprintf(stderr,"\t[-p]  number of elements per signal (integer) [256]\n");
	fprintf(stderr,"\t[-k]  desired THETA parameter for Kaiser window (float) [1]\n");
	fprintf(stderr,"\t[-e]  desired damping parameter for Exponential window (float, >= 0.0) [1]\n");
	fprintf(stderr,"\t[-b]  desired window width for User defined window (integer, >= 0) [1]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-w]  windowed output file to be created\n");
	fprintf(stderr, "\t\t0  (selection of Rectangular window ),\n");
	fprintf(stderr, "\t\t1  (selection of Bartlett window ),\n");
	fprintf(stderr, "\t\t2  (selection of Hamming window),\n");
	fprintf(stderr, "\t\t3  (selection of Hanning window),\n");
	fprintf(stderr, "\t\t4  (selection of Parzen window),\n");
	fprintf(stderr, "\t\t5  (selection of Kaiser window),\n");
	fprintf(stderr, "\t\t6  (selection of Exponential window),\n");
	fprintf(stderr, "\t\t7  (selection of Blackman window),\n");
	fprintf(stderr, "\t\t8  (selection of Blackman-Harris window),\n");
	fprintf(stderr, "\t\t9  (selection of Right-Triangular window),\n");
	fprintf(stderr, "\t\t10  (selection of Left-Triangular window),\n");
	fprintf(stderr, "\t\t11  (selection of Right-Exponential window),\n");
	fprintf(stderr, "\t\t12  (selection of Left-Exponential window),\n");
	fprintf(stderr, "\t\tor 13  (selection of Left-Triangular window)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'float'  (select data type),\n");
	fprintf(stderr, "\t\t or 'complex'  (choose data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dgwindow\n");
	fprintf(stderr, "\t[-U] Gives the usage for dgwindow\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dgwindow.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dgwindow.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dgwindow
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*s_pstr = 
	"\nEnter: (s) number of signals to generate \n        {integer [1] }: "; 
char	*p_pstr = 
	"\nEnter: (p) number of elements per signal \n        {integer [256] }: "; 
char	*k_pstr = 
	"\nEnter: (k) desired THETA parameter for Kaiser window \n        {float [1.000000] }: "; 
char	*e_pstr = 
	"\nEnter: (e) desired damping parameter for Exponential window \n        {float, >= 0.0 [1.000000] }: "; 
char	*b_pstr = 
	"\nEnter: (b) desired window width for User defined window \n        {integer, >= 0 [1] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*w_pstr = "\nEnter: (w) windowed output file to be created -- \n      \t\t0 (selection of Rectangular window )\n\t\t1 (selection of Bartlett window )\n\t\t2 (selection of Hamming window)\n\t\t3 (selection of Hanning window)\n\t\t4 (selection of Parzen window)\n\t\t5 (selection of Kaiser window)\n\t\t6 (selection of Exponential window)\n\t\t7 (selection of Blackman window)\n\t\t8 (selection of Blackman-Harris window)\n\t\t9 (selection of Right-Triangular window)\n\t\t10 (selection of Left-Triangular window)\n\t\t11 (selection of Right-Exponential window)\n\t\t12 (selection of Left-Exponential window)\n\t\tor 13 (selection of Left-Triangular window)\n  [0]:  "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'float' (select data type)\n\t\tor 'complex' (choose data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dgwindow", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dgwindow.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dgwindow: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dgwindow.ans");
		}

	     }

	}

	/*
	 * allocate the dgwindow structure
	 */
	dgwindow = (dgwindow_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dgwindow_struct));

	/*
	 * get required arguments for dgwindow
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dgwindow->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dgwindow->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dgwindow->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dgwindow->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dgwindow->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dgwindow
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dgwindow->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(dgwindow->trigger_file))
;

	dgwindow->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(dgwindow->s_int),
	1, 0, 0);

	dgwindow->p_flag = vget_int(fid, prompt_flag,
	"-p", p_pstr, &(dgwindow->p_int),
	256, 0, 0);

	dgwindow->k_flag = vget_float(fid, prompt_flag,
	"-k", k_pstr, &(dgwindow->k_float),
	1.000000, 3.000000, 3.000000);

	dgwindow->e_flag = vget_float(fid, prompt_flag,
	"-e", e_pstr, &(dgwindow->e_float),
	1.000000, 1.000000, 1.000000);

	dgwindow->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(dgwindow->b_int),
	1, 1, 1);

	dgwindow->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dgwindow->d_logic), 1);


	/*
	 * get optional toggles for dgwindow
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dgwindow->w_flag = vget_int(fid, prompt_flag,
		"-w", w_pstr, &(dgwindow->w_toggle),
		0, 0, 0);

		if ((dgwindow->w_toggle == 0 ) || 
		    (dgwindow->w_toggle == 1 ) || 
		    (dgwindow->w_toggle == 2 ) || 
		    (dgwindow->w_toggle == 3 ) || 
		    (dgwindow->w_toggle == 4 ) || 
		    (dgwindow->w_toggle == 5 ) || 
		    (dgwindow->w_toggle == 6 ) || 
		    (dgwindow->w_toggle == 7 ) || 
		    (dgwindow->w_toggle == 8 ) || 
		    (dgwindow->w_toggle == 9 ) || 
		    (dgwindow->w_toggle == 10 ) || 
		    (dgwindow->w_toggle == 11 ) || 
		    (dgwindow->w_toggle == 12 ) || 
		    (dgwindow->w_toggle == 13 ))
		      ok = TRUE;
		else
		{
		}
	    }
	    ok = FALSE;
	    while(!ok)
	    {
		dgwindow->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgwindow->t_toggle),
		"float");

		if (((strcmp(dgwindow->t_toggle, "float") == 0)) || 
		     ((strcmp(dgwindow->t_toggle, "complex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dgwindow->w_flag = vget_int(fid, prompt_flag,
		"-w", w_pstr, &(dgwindow->w_toggle),
		0, 0, 0);

		if ((dgwindow->w_toggle != 0 ) && 
		    (dgwindow->w_toggle != 1 ) && 
		    (dgwindow->w_toggle != 2 ) && 
		    (dgwindow->w_toggle != 3 ) && 
		    (dgwindow->w_toggle != 4 ) && 
		    (dgwindow->w_toggle != 5 ) && 
		    (dgwindow->w_toggle != 6 ) && 
		    (dgwindow->w_toggle != 7 ) && 
		    (dgwindow->w_toggle != 8 ) && 
		    (dgwindow->w_toggle != 9 ) && 
		    (dgwindow->w_toggle != 10 ) && 
		    (dgwindow->w_toggle != 11 ) && 
		    (dgwindow->w_toggle != 12 ) && 
		    (dgwindow->w_toggle != 13 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
		dgwindow->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgwindow->t_toggle),
		"float");

		if (((strcmp(dgwindow->t_toggle, "float") != 0)) && 
		     ((strcmp(dgwindow->t_toggle, "complex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



