 /*
  * Khoros: $Id: dgsin.c,v 1.2 1992/03/20 23:16:19 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dgsin.c,v 1.2 1992/03/20 23:16:19 dkhoros Exp $";
#endif

 /*
  * $Log: dgsin.c,v $
 * Revision 1.2  1992/03/20  23:16:19  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dgsin.c
 >>>>
 >>>>      Program Name: dgsin
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates a 1d sinusoidal data set.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:31:10 1992
 >>>>
 >>>>          Routines: main- the main program for dgsin
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dgsin.h"


/****************************************************************
 *
 * Routine Name:  main program for dgsin
 *
 *       Input:  
 *       -o  resulting image 
 *
 *
 *       [-i] input value file (xviff file)
 *       [-v] number of data sets  (value > 0)
 *       [-n] number of points  (value > 0)
 *       [-s] sampling frequency  (value > 0.0)
 *       [-m] maximum signal level 
 *       [-f] signal frequency  (value > 0.0)
 *       [-p] phase  
 *       [-b] initial delay  (value >= 0)
 *       [-h] radians per pixel (0) or hertz (1)
 *       [-d] data processing direction (0 = down vectors, 1 = across bands)
 *       [-t] lets user choose data type of image
 *		'float' (select data type),
 *		 or 'complex' (choose data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */

struct xvimage *image=NULL, *kernel=NULL, *readimage();
int type;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if(check_args())exit(1);
  if(!vget_type(&type,dgsin->t_toggle)){
     fprintf(stderr,"dgsin:  Invalid data type specified\n");
     exit(1);
  }

/*
** load kernel if necessary
*/

  if (dgsin->i_flag) {
    image = readimage(dgsin->i_file);
    if(image == NULL)
    {
      (void)fprintf(stderr,"dgsin:  Value file could not be read!\n");
      exit(1);
    }
  }

/* -main_before_lib_call_end */

/* -main_library_call */
  if(!ldgsin(&image,dgsin->v_int,dgsin->n_int,dgsin->s_float,
             dgsin->m_float,dgsin->f_float,dgsin->p_float,dgsin->b_int,
             type,dgsin->h_logic,dgsin->d_logic)){
    (void)fprintf(stderr, "ldgsin Failed\n");
    exit(1);
  }

/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(dgsin->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dgsin 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dgsin :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates a 1d sinusoidal data set.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"\nThe -t option will accept input in either of two forms:\n");
fprintf(stderr,"  an alphabetic representation, i.e. 'float' or 'complex',\n");
fprintf(stderr,"  or a numeric representation, such as 4 for real.\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  input value file (xviff file) (infile) [null]\n");
	fprintf(stderr,"\t[-v]  number of data sets (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-n]  number of points (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-s]  sampling frequency (float, > 0.0) [2]\n");
	fprintf(stderr,"\t[-m]  maximum signal level (float) [1]\n");
	fprintf(stderr,"\t[-f]  signal frequency (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-p]  phase  (float) [0]\n");
	fprintf(stderr,"\t[-b]  initial delay (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-h]  radians per pixel (0) or hertz (1) (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'float'  (select data type),\n");
	fprintf(stderr, "\t\t or 'complex'  (choose data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dgsin\n");
	fprintf(stderr, "\t[-U] Gives the usage for dgsin\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dgsin.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dgsin.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dgsin
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*i_pstr = 
	"\nEnter: (i) input value file (xviff file) \n        {infile}: "; 
char	*v_pstr = 
	"\nEnter: (v) number of data sets \n        {integer, > 0 [1] }: "; 
char	*n_pstr = 
	"\nEnter: (n) number of points \n        {integer, > 0 [256] }: "; 
char	*s_pstr = 
	"\nEnter: (s) sampling frequency \n        {float, > 0.0 [2.000000] }: "; 
char	*m_pstr = 
	"\nEnter: (m) maximum signal level \n        {float [1.000000] }: "; 
char	*f_pstr = 
	"\nEnter: (f) signal frequency \n        {float, > 0.0 [1.000000] }: "; 
char	*p_pstr = 
	"\nEnter: (p) phase  \n        {float [0.000000] }: "; 
char	*b_pstr = 
	"\nEnter: (b) initial delay \n        {integer, >= 0 [0] }: "; 
char	*h_pstr = 
	"\nEnter: (h) radians per pixel (0) or hertz (1) \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'float' (select data type)\n\t\tor 'complex' (choose data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dgsin", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dgsin.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dgsin: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dgsin.ans");
		}

	     }

	}

	/*
	 * allocate the dgsin structure
	 */
	dgsin = (dgsin_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dgsin_struct));

	/*
	 * get required arguments for dgsin
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dgsin->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dgsin->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dgsin->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dgsin->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dgsin->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dgsin
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dgsin->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(dgsin->i_file))
;

	dgsin->v_flag = vget_int(fid, prompt_flag,
	"-v", v_pstr, &(dgsin->v_int),
	1, 2, 2);

	dgsin->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(dgsin->n_int),
	256, 2, 2);

	dgsin->s_flag = vget_float(fid, prompt_flag,
	"-s", s_pstr, &(dgsin->s_float),
	2.000000, 2.000000, 2.000000);

	dgsin->m_flag = vget_float(fid, prompt_flag,
	"-m", m_pstr, &(dgsin->m_float),
	1.000000, 0.000000, 0.000000);

	dgsin->f_flag = vget_float(fid, prompt_flag,
	"-f", f_pstr, &(dgsin->f_float),
	1.000000, 2.000000, 2.000000);

	dgsin->p_flag = vget_float(fid, prompt_flag,
	"-p", p_pstr, &(dgsin->p_float),
	0.000000, 0.000000, 0.000000);

	dgsin->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(dgsin->b_int),
	0, 1, 1);

	dgsin->h_flag = vget_logic(fid, prompt_flag,
	"-h", h_pstr, &(dgsin->h_logic), 1);

	dgsin->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dgsin->d_logic), 1);


	/*
	 * get optional toggles for dgsin
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dgsin->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgsin->t_toggle),
		"float");

		if (((strcmp(dgsin->t_toggle, "float") == 0)) || 
		     ((strcmp(dgsin->t_toggle, "complex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dgsin->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgsin->t_toggle),
		"float");

		if (((strcmp(dgsin->t_toggle, "float") != 0)) && 
		     ((strcmp(dgsin->t_toggle, "complex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



