 /*
  * Khoros: $Id: poly_lex.l,v 1.2 1992/03/20 23:29:48 dkhoros Exp $
  */

 /*
  * $Log: poly_lex.l,v $
 * Revision 1.2  1992/03/20  23:29:48  dkhoros
 * VirtualPatch5
 *
  */ 

%{

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: poly_lex.l                             <<<<
   >>>>                                                       <<<<
   >>>>   description: lex source for polynomial parser       <<<<
   >>>>                                                       <<<<
   >>>>      routines: 					      <<<<
   >>>>                                                       <<<<
   >>>> modifications: Jeremy Worley Mar 19 1992 17:03:15 MST <<<<
   >>>>                Redefined the input and unput macros   <<<<
   >>>>                so that they use the transport stuff.  <<<<
   >>>>                Also added a couple of routines to     <<<<
   >>>>                service these macros.                  <<<<
   >>>>                                                       <<<<
   >>>>          NOTE: this routine is not for public use!    <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "xvparser.h"
#include "kfile.h"
#include "vpoly.h"
#include "y.tab.h"

extern YYSTYPE yylval;
int linecount = 0;
extern int func_count;
kfile *kflptr;
int c;
int _dwaiting = 0;   
int _dwaitchar, _dfgetc();
void _dungetc();

/*
** the following definitions stolen from xvparser:
*/

#undef output
#define output(c) 

#undef input
#define input() ((c = _dfgetc(kflptr))==EOF ? 0 : c)

#undef unput
/* #define unput(c) ungetc(c,flptr)  */
#define unput(c) _dungetc(c) 

%}

S	[ \t]*
B	[a-zA-Z][a-zA-Z0-9_]*
D	[0-9]
E	[eE][-+]?{D}+

%%


\n	{ linecount ++; }
"#".*		{ ; }		/* skip all csh style comments */
"/*"    {               /* skip everything inside a C style comment */
           register int cc;
           for (;;)
           {
              while ((cc = input()) != '*' && cc != EOF && cc != '\0')
                                ;
              if (cc == '*')
              {
                 if ((cc = input()) == '/')
                    break;
              }
              else
                 break;
           }
        }

{S}		{ ; }		/* skip all blanks, etc. */

{D}+			|
{D}+"."{D}*({E})?	|
{D}*"."{D}+({E})?	|
{D}+{E}			{
			  yylval.type = NUMBER;
			  sscanf(yytext," %f",&(yylval.value));
			  yylval.order = 0.0;
			  strcpy(yylval.string,yytext);
			  return(yylval.type);
			}

"const" { 
	  yylval.type = CONST;
	  yylval.value = 0.0;
	  yylval.order = 0.0;
	  return(yylval.type); 
	}

"stats"	{ 
	  fprintf(stderr,"line count:  %d\nfunction count:  %d\n",
          linecount,func_count); 
	}

"end"	{ 
	  yylval.type = END;
	  yylval.value = 0.0;
	  yylval.order = 0.0;
	  return(yylval.type);
	}


";"	{ 
	  yylval.type = TERM;
	  yylval.value = 0.0;
	  yylval.order = 0.0;
	  return(yylval.type); 
	}	

","	{ return(','); }
"("	{ return('('); }
")"	{ return(')'); }
"["	{ return('['); }
"]"	{ return(']'); }
"="	{ return('='); }
"+"	{ return('+'); }
"-"	{ return('-'); }
"*"	{ return('*'); }
"/"	{ return('/'); }
"^"	{ 
	  yylval.type = EXPON;
	  yylval.value = 0.0;
	  yylval.order = 0.0;
	  return(yylval.type); 
	}
"**"	{ 
	  yylval.type = EXPON;
	  yylval.value = 0.0;
	  yylval.order = 0.0;
	  return(yylval.type); 
	}

{B}*			{
			  if(!clookup(yytext,&yylval.value)){ 
			     yylval.type = WORD;
			     strcpy(yylval.string,yytext); 
			  }else{
			     yylval.type = NUMBER;
			  }
			  return(yylval.type);
			}


%%

int clookup(name,value)
    char *name;
    float *value;
{
    int i=0;

    if(name==NULL)return(0);

    while(constants[i].name!=NULL){
       if(strcmp(name,constants[i].name)==0){
          *value = (float)constants[i].value;
           return(1);
       }
       i++;
    }

    return(0);
}

/***********************************************************************
*
*  Routine Name: _dfgetc()
*
*          Date: Thu Mar 19 17:09:07 MST 1992
*        
*       Purpose: implements an fgetc with the ability to get chars
*                that have been ungotten.  
*
*         Input: kfile *kf - transport object ala Mark Young 
*
*        Output: returns either EOF or a character 
*
*    Written By: Jeremy Worley 
*
* Modifications:
*
***********************************************************************/

int _dfgetc(kf)
  kfile *kf;
{
  if(!_dwaiting)return(kfgetc(kf));

  _dwaiting = !_dwaiting;

  return(_dwaitchar);
}

/***********************************************************************
*
*  Routine Name: _dungetc(c)
*
*          Date: Thu Mar 19 17:10:52 MST 1992
*        
*       Purpose: implements an unget capability with the transport
*                software.  
*
*         Input: int c - the character to be ungotten 
*
*        Output: nothin' man!!!
*
*    Written By: Jeremy Worley 
*
* Modifications:
*
***********************************************************************/

void _dungetc(c)
  int c;
{
  _dwaiting = 1;
  _dwaitchar = c;
}
