#! /bin/csh -f
#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: phantom                                <<<<
#  >>>>                                                       <<<<
#  >>>>   description: start the daemon on the remote machine <<<<
#  >>>>                                                       <<<<
#  >>>> modifications:					      <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

# ROUTINE NAME:	phantom
# 
# AUTHORS:	Mark Young and Steven Jorgensen
# 
# DATE:		11/15/91
# 
# DESCRIPTION:	Script used to start remote daemon
# 
# MODIFICATIONS:   From (Konstantin) kk@hpkronos.hpl.hp.com (Jan 10 1992)
#
#		There are a number of bugs in the phantom script
#		First, the "shift" before the "while" is not required.
#		if machine=$argv[1] and you shift, there is no more argv[1].
#		 
#		Then the script assumes that everyone is using csh.
#		Not a good idea, since lots of us use ksh.
#
#
#
# CALLED FROM:  transport routines (or users wishing to start the
#		daemon by hand).
#


set path = ( $path /usr/local/bin /usr/new /usr/ucb /usr/bin /bin \
    /usr/local/etc/ /usr/etc /etc/ /usr/hosts $KHOROS_HOME/bin . )

onintr cleanup

set PROMPT_FLAG  = 0
set RHOSTMOVED = 0
set outstat = 0
set phantom_opts = ""
if ($SHELL != /bin/ksh ) then
set phantom_cmd = "$KHOROS_HOME/bin/phantomd -daemon true"
else
set phantom_cmd = "export KHOROS_HOME=$KHOROS_HOME; $KHOROS_HOME/bin/phantomd -daemon true"
endif
if ($SHELL != /bin/ksh ) then
	if ($?DISPLAY ) then
  	set display_cmd = "setenv DISPLAY $DISPLAY ; "
	else
  	set display_cmd = ""
	endif
else
	if ($?DISPLAY ) then
	set display_cmd = "export DISPLAY=$DISPLAY ; "
        else
        set display_cmd = ""
	endif
endif

set TEMPDIR = /tmp
if ($#argv < 1) then
  goto usage
endif
set machine = $argv[1]
#shift
while ($#argv)
        switch("$argv[1]")
            case -U:
                goto usage
                breaksw
            case -V:
                echo ""
		echo "phantom:  Khoros Version: 1, Release: 0"
                echo ""
                exit (1)
                breaksw
	    default:
                 set phantom_opts = "$phantom_opts $argv[1]"
                breaksw

        endsw
        shift
end

if ((! -e ~/.rhosts) && -e ~/.rhosts.bk ) then
  set RHOSTMOVED = 1
  cp ~/.rhosts.bk ~/.rhosts
endif

echo ""
echo "Starting phantom daemon for machine: $machine"
echo ""
rsh $machine "$display_cmd  $phantom_cmd "  < /dev/null >& /dev/null
set stat = $status
if (! -e /vmunix && $stat != 0) then
    remsh $machine -n "$display_cmd  $phantom_cmd " < /dev/null >& /dev/null
    set stat = $status
endif

if ($stat != 0) then
  if ( $?DISPLAY ) then
    xterm -e /bin/csh -cf " echo ''; echo ''; \
		    echo '' \
		    echo Starting phantom daemon for machine: $machine \
		    echo '' \
		    echo Can not Startup remote daemon using remote shell ; \
		    echo Login to the remote machine, and execute.; \
		    echo ''; echo '      $phantom_cmd' $phantom_opts ; \
		    echo '' \
		    echo After the phantom daemon starts, exit this xterm to \
		    echo continue the execution of the remote process. \
		    echo ''; sleep 4 ; rlogin $machine" -e 
    set outstat = $status
  else
    echo "Can't execute remote command, Login to remote machine, and exectute:"
    echo ""
    echo "        $phantom_cmd $phantom_opts"
    echo ""
    set outstat = 1
  endif
endif

   
###
###    the cleanup for phantom script
###

cleanup:
 
    if ( $RHOSTMOVED ) then
      /bin/rm -f ~/.rhosts
    endif

exit ($outstat)

###
###    the usage statement for phantom
###
 
usage:
    echo ""
    echo "phantom: "
    echo ""
    echo "	phantom machine [phantomd_opts]"
    echo ""
    echo "	This program is a remote excution daemon for the"
    echo "	distributed computing mechanism."
    echo ""
    echo "        [-V] Gives the release and version number"
    echo "        [-U] Gives the usage for bldmanual"
    echo "        [-P] Prompts for command line options"
    echo ""
    exit 0
 

