 /*
  * Khoros: $Id: ck_bnds_flt.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: ck_bnds_flt.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: ck_bnds_flt.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 

/******************************************************************

	Check Bounds on a Floating Point Argument

	source filename:			check_bounds_float.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		Jan-05-85		don hush

******************************************************************

	usage
	-----

	stat = check_bounds_float(farg,fmax,fmin)

	int stat;
	float farg,fmax,fmin;

	description
	-----------

	  Checks to see if farg is within the specified bounds.
	If not a -1 is returned , otherwise a 0 is returned.
	If fmax == fmin then,
		if fmax = -2.0 farg is checked for a value < 0
			(returns stat of -3 if not)
		if fmax = -1.0 farg is checked for a value <= 0
			(returns stat of -2 if not)
		if fmax = 1.0 farg is checked for a value >= 0
			(returns stat of 1 if not)
		if fmax = 2.0 farg is checked for a value > 0
			(returns stat of 2 if not)
		otherwise no checking is done

******************************************************************/

check_bounds_float(farg,fmax,fmin)

float farg,fmax,fmin;

{
    if (fmax < fmin )
       return(0);	/* bounds checking is suppressed */

    if (fmax == fmin) {

	switch ((int) fmax) {

	    case -2 :
		if (farg < 0.0)
		    return(0);
		else
		    return(-3);
		break;

	    case -1 :
		if (farg <= 0.0)
		    return(0);
		else
		    return(-2);
		break;

	    case 1 :
		if (farg >= 0.0)
		    return(0);
		else
		    return(1);
		break;

	    case 2 :
		if (farg > 0.0)
		    return(0);
		else
		    return(2);
		break;
	    default :			/* suppress bounds checking */
		return(0);
		break;
	}
    }
    else if ( (farg>=fmin) && (farg<=fmax) )
	return(0);

    return(-1);
}
