 /*
  * Khoros: $Id: Tli.h,v 1.3 1992/03/20 23:39:11 dkhoros Exp $
  */

 /*
  * $Log: Tli.h,v $
 * Revision 1.3  1992/03/20  23:39:11  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name: Tli.h					<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _Tli_h_
#define _Tli_h_

/* transport layer interface (sysV) structure */
#include <tiuser.h>


/*
 *  Internal structures for the following transport
 *
 *		tli	   -  (Sys V) Transport Layer Interface
 */

/* transport layer interface structure */
typedef struct
{
	int dummy; /* make compilier happy */
} TliStruct;

#undef  ResourceStruct
#define ResourceStruct TliStruct


int	tli_tempnam(),
	tli_open(),
	tli_close(),
	tli_read(),
	tli_write(),
	tli_lseek(),
	tli_tell(),
	tli_unlink(),
	tli_lock(),
	tli_descriptors(),
	tli_exec(),
	tli_machtype(),
	tli_gethostname();

static RemoteInformation remote_tli_routines[] =
{
    {
	tli_exec,
	tli_machtype,
	tli_gethostname,
    }
};

static TransportInformation tli_routines[] =
{
    {
	"(sysV) Transport Layer Interface",
	"tli",
	FALSE,
	tli_tempnam,
	tli_open,
	tli_close,
	tli_read,
	tli_write,
	tli_lseek,
	tli_tell,
	NULL,
	tli_unlink,
	tli_lock,
	tli_descriptors,

	remote_tli_routines,
    }
};

#endif /* _Tli_h_ */
/* don`t add after the endif */
