 /*
  * Khoros: $Id: ghost.h,v 1.4 1992/03/20 22:34:53 dkhoros Exp $
  */

 /*
  * $Log: ghost.h,v $
 * Revision 1.4  1992/03/20  22:34:53  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */
#include "unmcopyright.h"        /* Copyright 1990 by UNM */

#ifndef _ghost_h_
#define _ghost_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>      file: ghost.h                                       <<<<
   >>>>                                                          <<<<
   >>>>      contains:  #defines and routine declarations used   <<<<
   >>>>			by the ghost library, the ghostreader    <<<<
   >>>>			and ghostwriter programs.                <<<<
   >>>>                                                          <<<<
   >>>>      written by: Danielle Argiro                         <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

 
/************************************************************************
 *                                                                      *
 *              Global Definitions 					*
 *                            		                                *
 ************************************************************************/

/*  #Defines for general use */

#define MaxFileName      15 
#define MaxProgName       9
#define MaxCmdArgs      200
#define MaxMEGroups      50
#define MaxToggles       75
#define MaxProgSpecSize  30
#define MaxLineLength    80
#define MaxTextBlock     200
#define MaxKraftInfo	 11
#define MaxKraftConfig	 4

#ifndef MaxLength
#define MaxLength 512
#endif

/* #Defines for output of syntax */

#define MainHeader     	1
#define Man1Usage     	2
#define VGCUsage     	3
#define VGCGetArgs     	4
#define VGCpstrs        5

/* #defines for Keynames */

#define Authors			0	/* -authors */
#define ShortProgDesc		1       /* -short_prog_description */
#define ShortLibDesc		2	/* -short_lib_description  */

#define Man1LongDesc		3       /* -man1_long_description  */
#define Man1Examples		4	/* -man1_examples */
#define Man1Restrictions	5	/* -man1_restrictions */
#define Man1SeeAlso		6	/* -man1_see_also */

#define Man3LongDesc     	7	/* -long_lib_description */
#define Man3Restrictions	8	/* -man3_restrictions */
#define Man3SeeAlso		9	/* -man3_see_also */

#define UsageAdd		10	/* -usage_additions */

#define IncludeIncludes		11	/* -include_includes */
#define IncludeAdd		12	/* -include_additions */
#define IncludeMacros		13	/* -include_macros */

#define MainVariables		14	/* -main_variable_list */
#define MainBeforeLib		15	/* -main_before_lib_call */
#define MainLibCall		16	/* -man_library_call */
#define MainAfterLib		17	/* -main_after_lib_call */

#define LibraryInput		18      /* -library_input */
#define LibraryOutput		19      /* -library_output */
#define LibraryDef		20	/* -library_def */
#define LibraryCode		21	/* -library_code */
#define LibraryIncludes		22	/* -library_includes */
#define LibraryMods		23	/* -library_mods */

/* #defines for text formatter */

#define NO_TEXT_FORMATTER 0
#define NROFF_FORMATTER   1


/* #defines for gw_get_prog_info() status */

#define BEGIN_KEY_NOT_FOUND 1
#define END_KEY_NOT_FOUND   2
#define EMPTY_TEXT_BLOCK    3
#define VALID_TEXT_BLOCK    4


/* #defines for config file string arrays */
#define CPATH        0
#define HPATH        1
#define LPATH        2
#define MAN1PATH     3
#define MAN3PATH     4
#define PROGPATH     5
#define PANEPATH     6
#define HELPPATH     7
#define SUBHELPPATH  8
#define TOPSRC       9

#define ConfigKeyNum 10

/* #defines for a toolbox log file */
#define VersionNum  0
#define AuthorsList 1
#define RevisionLog 2
#define LibPath     3
#define BinPath     4
#define LibSearch   5
#define IncSearch   6
#define CompDef     7
#define ToolLibs    8
#define XLibs       9
#define ForLibs     10

/* #defines for Kraftsman Config file */
#define DirFlag    0
#define FileCreate 1
#define FileVars   2
#define VarDefs	   3

/****************************************************************
 *								*
 *		Function Declarations				*
 *								*
 ****************************************************************/


        char **gw_read_progfile();
	char **gw_read_kraft_config();
        char *gw_get_prog_info();
	char *gw_copyright();

	char *ascii_def_val();
	char *ascii_name();

        char **get_text_lines();
	char  *add_gw_format();
	char  *delete_gw_format();

#endif /* _ghost_h_ */
/* Don't add anything after the endif */
