 /*
  * Khoros: $Id: pbm.h,v 1.1 1991/05/10 04:13:15 khoros Exp $
  */

 /*
  * $Log: pbm.h,v $
 * Revision 1.1  1991/05/10  04:13:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: pbm.h                                  <<<<
   >>>>                                                       <<<<
   >>>>      contains: contains defines to pbm		      <<<<
   >>>>                Portable bitmap file format.	      <<<<
   >>>>                                                       <<<<
   >>>>      written by: Mark Young 			      <<<<
   >>>>                                                       <<<<
   >>>>      date: 10/10/90                                   <<<<
   >>>>                                                       <<<<
   >>>>      modifications:				      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _pbm_h_
#define _pbm_h_


/*
 *                       
 *	The "pbm" image file format describes the format used by
 *	the pbm conversion routines.  The format was developed
 *	by Jef Poskanzer.
 *
 *	The pbm format is really three different formats; pbm, pgm, &
 *	ppm.  The formats correspond to bitmap, greymap, and pixmap
 *	formats.
 *
 *	The following structure is used by the conversion routines to read
 *	and write the pbm files.  This format is not a standard, just an
 *	intermediate format used by the Khoros routines to do convert pbm
 *	files to and from the viff format.
 *
 */

struct pbm {

	int type;			/* type of pbm image         */
	int raw;			/* image is in raw format    */

	int  width, height;		/* width and height of image */
	int  maxval;			/* maximum value of image    */
	char *data;			/* image data		     */
};

struct pbm *read_pbm(), *free_pbm();
int	   write_pbm(), info_pbm();

/*
 *  Defines used to indicate the type of pbm file.  PBM represents a
 *  bitmap image, PGM represents a greymap image, PPM represents a
 *  pixmap (24 bit color) image.
 */
#define	PBM	1
#define	PGM	2
#define	PPM	3

#endif

/* Don't add after the endif */
