/* copyright 1987, 1988, 1989 by Phil Andrews */
/* module to decode a PK format packed raster font description */
/* globals for pk processing */
#include <stdio.h>
#include "defs.h"
#define NO_FONTS 8	/* the number of font styles pre-defined */
#define max_mags 100
#define pts_in 72.27
#define base_pxl_per_in 300
#define rfudge 1.728
#define byte_size 8
#define word_size (sizeof(int) * byte_size)
#ifdef VMS
#define TROUBLE 0
#else
#define TROUBLE 1
#endif

/* a few pk specific globals */

static int hoff, voff, bit_weight, h_dots, v_dots, glyph_width, 
glyph_height = 77;

static unsigned tfm, dm, wpk, hpk, dx, dy, ds, cs, hppp, vppp;
static float dpi;
static unsigned char input_byte, nybble;
static unsigned char turn_on;
static int repeat_count, rows_left, h_bit, count, dyn_f, row_bytes, width_bytes;

#define r_b_allocated 8 * 1024
static int bytes_allocated = r_b_allocated;
static int rot_bytes_allocated = r_b_allocated;
static char ras_array[r_b_allocated], rot_array[r_b_allocated];
static char *ras_ptr = ras_array, *rot_ptr = rot_array;
extern char *realloc();

#define max_char_stor 100000
static unsigned char char_stor[max_char_stor];	/* store character definitions */
static unsigned char *char_stor_ptr = char_stor;

/* numbers */
#define shift8 256
#define shift16  0200000
#define shift20 04000000

/* the caching structure, used in CACHE.C */
static struct record_type crec;
/* heavy stuff, here start the conversion from .pk format to proprietary QMS
   format  note see TUGBOAT, vol 6, no. 3, Nov. 85 or the PKTYPE.WEB program 
   for documentation on PK files, Phil Andrews */
/* constants needed here */

/* these are to take care of specials in MF files, probably not used much */
#define pk_xxx1 240
#define pk_xxx2 241
#define pk_xxx3 242
#define pk_xxx4 243
#define pk_yyy  244

/* beginning of postamble etc. */
#define pk_post 245
#define pk_no_op 246

/* beginning of preamble */
#define pk_pre 247

/* the expected pk_id */
#define pk_id 89
#define bit_raster 14

/* keep some variables here for the font look_ups */
static char font_dir[max_str] = "";	/* font directory */
#ifdef VAXC
#define fdef_dir "TEX$PK"	/* VMS default font directory */
#define log_tab "LNM$FILE_DEV"	/* VMS logical name table */
#endif
/* function to check and set up the font directory structure */
check_fdir(out_str)
char *out_str;
{
char exp_str[max_str];
int result, use_decnet, dir_len, i;

	if (font_dir[0]) return(1);	/* already done */
#ifdef VAXC
	result = translate(fdef_dir, log_tab, exp_str);
	if (!result) return(0);		/* no translation */
	/* now lets see if we're working accross decnet */
	use_decnet = 0;
	dir_len = strlen(exp_str);
	for (i = 0; (i < (dir_len - 1)) && (!use_decnet); ++i)
	    use_decnet = (exp_str[i] == ':') && (exp_str[i + 1] == ':');

	if (use_decnet) {	/* we'll be getting fonts accross decnet */
	    strcpy(font_dir, exp_str);	/* copy over the result */
	    if ((font_dir[dir_len - 1] == ']') && 
		(font_dir[dir_len - 2] == '.')) 
		font_dir[dir_len - 1] = '\0';	/* trim it */
	    else {
	    	fprintf(stderr, "can't use %s accross decnet!\n", font_dir);
	    	return(0);
	    }
	} else {		/* can use the rooted directory */
	    strcpy(font_dir, fdef_dir);	/* copy over the result */
	    /* and add a ":[" to the end */
	    strcat(font_dir, ":[");
	}
	if (out_str) strcpy(out_str, font_dir);
	return(result);
#else
#ifdef UNIXFONTS
	strcpy(font_dir, UNIXFONTS);
	if (out_str) strcpy(out_str, font_dir);
	return(1);
#else
	return(0);
#endif
#endif
}
/* do most of the work here */
char *process_char(flag, pl, cc, do_rotate, bwidth, rheight, rwidth, tfm_width,
	pxl_width, pk_file, h_dots, v_dots, long_rows)
int do_rotate, *bwidth, *rheight, *rwidth, *tfm_width, *pxl_width,
*h_dots, *v_dots, long_rows;
unsigned char flag;
unsigned int  pl;
char cc;
FILE *pk_file;
{
unsigned char flag_byte, byte_mask;
int ras_bytes, rot_bytes, i, j, rot_row_bytes, rot_width_bytes;
#define no_rotate (!do_rotate)	/* fix later */

    
    /* first read the character preamble */
    dyn_f = flag / 16;
    flag_byte = flag % 16;
    turn_on = (flag_byte >= 8);
    if (turn_on) flag_byte -= 8; 
    
    if (flag_byte == 7) read_long(pk_file);

    else { 
	if (flag_byte > 3) read_ext(pk_file);
	else read_short(pk_file);
    }

    *tfm_width = tfm;
    *pxl_width = dx / shift16;	/* try this */

    if ( (wpk==0) || (hpk==0) ) {
	*bwidth = 0;
	*rwidth = 0;
	*rheight = 0;
	return(NULL);

    }

/* now do tougher stuff, i.e., the raster data */
/* we will put the character description in a bitarray ,
everything is recorded by horizontal rows, so we will use
(width + 7) / 8 bytes times height	*/
/* note that we may use an array that is larger than necessary, e.g., to
facilitate conversion to another font format. row_bytes contains the
actual no. of bytes in one row of the raster array, width_bytes contains
the minimum no. */

    width_bytes = (wpk + byte_size - 1) / byte_size;
    if (long_rows) row_bytes =  2 * ( (width_bytes + 1) / 2);
    else row_bytes = width_bytes;	/* default */

    ras_bytes = row_bytes * hpk;

    if (ras_bytes > bytes_allocated) {
	if ( (ras_ptr = realloc(ras_ptr, ras_bytes)) == 0) {
	    fprintf(stderr, "\ncouldn't reallocate enough memory");
	    fprintf(stderr, ", RAS_bytes = %d, allocated = %d", ras_bytes,
		bytes_allocated);
	    exit(TROUBLE);
	}
	else bytes_allocated = ras_bytes;
    }

    /* zero the raster */
    for (i = 0; i < ras_bytes; ++i) *(ras_ptr + i) = 0;

    /* now try to get the real raster */

    bit_weight = 0;
    if (dyn_f == bit_raster) get_bit_raster(ras_ptr, pk_file, wpk, hpk);
    else get_normal_raster(ras_ptr, pk_file, wpk, hpk);

    /* and make sure we haven't left anything in illegal part of array */

    byte_mask = ~0 << ((width_bytes * byte_size - wpk) % byte_size);

    for (i = width_bytes - 1; i < ras_bytes; i += row_bytes){
	*(ras_ptr + i) &= byte_mask;
	for (j=1; j<= (row_bytes - width_bytes); ++j)
	    *(ras_ptr + i + j) = 0;
    }

/* note that the natural PK orientation (horizontal rows) corresponds to
landscape orientation for the QMS1200 and portrait for the QMS800 */
/* however it is the natural orientation for the imagen */

    if (no_rotate) {	
	*bwidth = row_bytes;
	*rwidth = wpk;
	*rheight = hpk;
	*v_dots =  - voff;
	*h_dots =  - hoff;
	return(ras_ptr);
    }

    /* now handle rotation */
    *v_dots =  - hoff;
    *h_dots =  glyph_height - hpk + voff;

    rot_width_bytes = (hpk + byte_size - 1) / byte_size;
    if (long_rows) rot_row_bytes = 2 * ( (rot_width_bytes + 1) / 2);
    else rot_row_bytes = rot_width_bytes;	/* default */

    rot_bytes = rot_row_bytes * wpk;

    if (rot_bytes > rot_bytes_allocated) {
	if ( (rot_ptr = realloc(rot_ptr, rot_bytes)) == 0) {
	    fprintf(stderr, "\ncouldn't reallocate enough memory for rot_ptr");
	    fprintf(stderr, ", rot_bytes = %d, allocated = %d", rot_bytes,
		rot_bytes_allocated);
	    exit(TROUBLE);
	}
	else rot_bytes_allocated = rot_bytes;
    }

    /* zero the raster */
    for (i = 0; i < rot_bytes; ++i) *(rot_ptr + i) = 0;

    rotate_raster(ras_ptr, rot_ptr, hpk, wpk, rot_row_bytes);

    *bwidth = rot_row_bytes;
    *rwidth = hpk;
    *rheight = wpk;
    return(rot_ptr);
    
}
get_bit_raster(in_ptr, pk_file, width, height)
char *in_ptr;
unsigned width, height;
FILE *pk_file;
{
char *cur_ptr;
int i, j, k, bits_left;

    bits_left = width % byte_size;
    cur_ptr = in_ptr;
    for (i = 0; i < height; ++i){
	for (j = 0; j < width / byte_size; ++j){
	    for (k=byte_size-1; k >= 0; --k)
		if (get_bit(pk_file)) *cur_ptr |= (1 << k);
	    ++cur_ptr;
	}
	if (bits_left != 0) {
	    for (k=byte_size-1; k >= byte_size - bits_left; --k)
	    	if (get_bit(pk_file)) *cur_ptr |= (1 << k);
	    ++cur_ptr;
	}
	for (j=0; j<row_bytes-width_bytes; ++j) ++cur_ptr;
    }

    return(1);

}

/* adapted from pktype to turn on the raster array */
/* if do_repeat then the present row is to be repeated value times, 
else we have a run_count of value bits on or off, depending on turn_on */
get_normal_raster(in_ptr, pk_file, width, height)
char *in_ptr;
unsigned width, height;
FILE *pk_file;
{
int i, j, bit_ptr;;

    bit_ptr = 0;
    rows_left = height;
    h_bit = width;
    repeat_count = 0;
    
    while (rows_left > 0) {
	count = pk_packed_num(pk_file);
	if (turn_on) make_black(in_ptr, bit_ptr, count, width);
	bit_ptr += count;
/* for checking 	send_out(0, count); */
	if (count >= h_bit) {
	    if (repeat_count >0 ) dup_lines(in_ptr, bit_ptr, repeat_count,
		width, count);
	    bit_ptr += repeat_count * width;
	    rows_left -= repeat_count + 1;
	    repeat_count = 0;
	    count -= h_bit ;
	    h_bit = width ;
	    rows_left -= count / width ;
	    count %= width ;
	}
	h_bit -= count ;
	turn_on = !turn_on ;
    }
    if ((rows_left != 0) || (h_bit != width)) {
	fprintf(stderr, "\ntrouble !, rows_left = %d (0), h_bit = %d (%d)",
	    rows_left, h_bit, width);
	exit(TROUBLE);
    }
    if (bit_ptr != height * width) fprintf(stderr, "\ntrouble!, bit_ptr = %d",
	bit_ptr);
    return(1);
}
/* we here turn on count bits starting bit_ptr away from in_ptr */
/* note that we have assumed width set up array and that we take care
of zeroing bits outside of width*height array elsewhere */

make_black(in_ptr, bit_ptr, count, width)
char *in_ptr;
int bit_ptr, count;
unsigned width;
{
int first_byte, last_byte, i, bits_left, offset;
unsigned char byte_mask;

    first_byte =  ((bit_ptr / width) * row_bytes )
	+ ( (bit_ptr % width) / byte_size );

    last_byte =  (( (bit_ptr + count - 1)  / width) * row_bytes )
	+ ((count + bit_ptr - 1) % width) / byte_size;

    for (i = first_byte + 1; i < last_byte; ++i) *(in_ptr + i) = ~0;

    if (last_byte > first_byte){
	bits_left = byte_size - ( (bit_ptr % width) % byte_size );
	offset = 0;
    }
    else {
	bits_left = count;
	offset = byte_size-(((bit_ptr + count -1)% width) % byte_size) - 1;
    }

    byte_mask = ( ~(~0 << bits_left) ) << offset;

    *(in_ptr + first_byte) |= byte_mask;

    if (last_byte == first_byte) return(1);

    offset = byte_size - ( ((bit_ptr + count -1)% width) % byte_size) - 1;

    byte_mask = ~0 << offset;

    *(in_ptr + last_byte) |= byte_mask;

    return(1);
}
/* go here to duplicate previous lines, note that count may have been big 
enough to move us more than one row past the row to be duplicated */
dup_lines(in_ptr, bit_ptr, repeat_count, width, count)
char *in_ptr;
int bit_ptr, repeat_count, count;
unsigned width;
{
int i, j, present_row, dup_row;
    
/* first move the rows after the duplicated row up to where they should be */

    present_row = bit_ptr / width;
    dup_row = (bit_ptr - count) / width;

    for (i = present_row; i> dup_row; --i)
	for (j=0; j<row_bytes; ++j)
	    *(in_ptr + i * row_bytes + repeat_count * row_bytes + j)
	     = *(in_ptr + i * row_bytes + j);
	
/* now insert the repeated lines */

    for (i=1; i<=repeat_count; ++i)
	for (j=0; j<row_bytes; ++j)
	    *(in_ptr + dup_row * row_bytes + i * row_bytes + j)
	     = *(in_ptr + dup_row * row_bytes + j);		

    return(1);
}

rotate_raster(ras_ptr, rot_ptr, h, w, rot_row_bytes)
char *ras_ptr, *rot_ptr; 
int h, w, rot_row_bytes;
{
int i, j, k;

    for (i=0; i<h; ++i)
	for (j=0; j<width_bytes; ++j)
	    for (k=1; k<=byte_size; ++k)
		if (*(ras_ptr + i * row_bytes + j) & (1 << (byte_size-k)))
		    *(rot_ptr + (j * byte_size + k - 1) * rot_row_bytes 
			+ ((h - i - 1) / byte_size )) |= 
			    (1 << (byte_size -((h-i-1)%byte_size) - 1));

    return(1);
}

pk_packed_num(pk_file)
FILE *pk_file;
{
int i, j, k, temp;
    i = get_nyb(pk_file) ;
    if (i == 0){
	j = get_nyb(pk_file);
	++i;
	while (j == 0){
	    j = get_nyb(pk_file);
	    ++i;
	}
	while (i > 0){
	    j = j * 16 + get_nyb(pk_file);
	    --i;
	}
	temp = j - 15 + (13-dyn_f)*16 + dyn_f ;
    }
    else {
	if (i <= dyn_f) temp = i;
	else { 
	    if (i < 14) temp = (i-dyn_f-1) * 16 +
		get_nyb(pk_file) + dyn_f + 1;
	    else {
		if (repeat_count != 0 ) {
		    fprintf(stderr, "\nSecond repeat count for this row!");
		    exit(TROUBLE);
		}
		if (i == 14) repeat_count = pk_packed_num(pk_file);
		else repeat_count = 1;
/* for checking 		send_out(1, repeat_count); */
		temp = pk_packed_num(pk_file);
	    }
	}
    }
    return(temp);
}
/* this routine prints on the tty the runcounts, used as a check */

send_out(do_repeat, value)
int do_repeat, value;
{


    if (do_repeat) fprintf(stderr, "[%d]", value);
    else {
	if (turn_on) fprintf(stderr, "%d", value);
	else fprintf(stderr, "(%d)", value) ;
    }
    return(1);
}

show_raster(in_ptr, w_bytes, height)
char *in_ptr;
unsigned w_bytes, height;
{
unsigned char *cur_ptr;
unsigned temp;
int i, j, k;

    cur_ptr = (unsigned char *) in_ptr;
    fprintf(stderr, "\n");
    for (i = 0; i < height; ++i){
	fprintf(stderr, "\n  ");
	for (j = 0; j < w_bytes; ++j){
	    for (k=byte_size-1; k >= 0; --k)
		if (*cur_ptr & (1 << k)) fprintf(stderr, "*");
		else fprintf(stderr, " ");
	    ++cur_ptr;
	}
    }

    return(1);

}
read_long(pk_file)
FILE *pk_file;
{
    pkread(&tfm, 4, 0, pk_file);
    pkread(&dx, 4, 0, pk_file);
    pkread(&dy, 4, 0, pk_file);
    pkread(&wpk, 4, 0, pk_file);
    pkread(&hpk, 4, 0, pk_file);
    pkread(&hoff, 4, 1, pk_file);
    pkread(&voff, 4, 1, pk_file);

    return(1);
}
read_ext(pk_file)
FILE *pk_file;
{
    pkread(&tfm, 3, 0, pk_file);
    pkread(&dx, 2, 0, pk_file);
    dx *= shift16;
    dy = 0;
    pkread(&wpk, 2, 0, pk_file);
    pkread(&hpk, 2, 0, pk_file);
    pkread(&hoff, 2, 1, pk_file);
    pkread(&voff, 2, 1, pk_file);

    return(1);
}
read_short(pk_file)
FILE *pk_file;
{
    pkread(&tfm, 3, 0, pk_file);
    pkread(&dx, 1, 0, pk_file);
    dx *= shift16;
    dy = 0;
    pkread(&wpk, 1, 0, pk_file);
    pkread(&hpk, 1, 0, pk_file);
    pkread(&hoff, 1, 1, pk_file);
    pkread(&voff, 1, 1, pk_file);

    return(1);
}
read_pk_preamble(pk_file, ds, cs, hppp, vppp)
FILE *pk_file;
int *ds, *cs, *hppp, *vppp;
{
unsigned char i, j, k;
char x[256];

    if ( (j=getc(pk_file)) != pk_pre) 
	fprintf(stderr, "\nwrong first byte! %d, not %d", j, pk_pre);

    if ( (i = getc(pk_file))	/* id_byte */
	!= pk_id) fprintf(stderr, "\nwrong id byte! %d, not %d", i, pk_id);

    k = getc(pk_file);	/* no. of chars in msg */

    for (j=0; j<k; ++j) x[j] = getc(pk_file);
    x[k] = '\0';


/* now get design size and checksum */

    pkread(ds, 4, 0, pk_file);	/* design size */

    pkread(cs, 4, 0, pk_file);	/* check sum */

/* don't worry about checksum here for now */

    pkread(hppp, 4, 0, pk_file);	/* hor pxls per pt */

    pkread(vppp, 4, 0, pk_file);	/* ver pxls per pt */

    dpi = (*hppp * 72.27)  / shift16;

    return(i);
}

pkread(target, no_bytes, has_sign, pk_file)
FILE *pk_file;
int no_bytes, has_sign, *target;
{
unsigned result, first_byte;
int i;

    result = getc(pk_file);
    first_byte = result;
    for  (i=1;i<no_bytes;++i) result = (result<<byte_size) + getc(pk_file);

/* now check for negative values, if so turn on high order bits */

    if ( has_sign && (first_byte > 127) )	/* meant to be negative */
	result |=  ~0 << (no_bytes * byte_size); /* sneaky ! */

    *target = result;
    return(result);
}

get_nyb(pk_file)
FILE *pk_file;
{
int temp;
    if (bit_weight == 0) {
	input_byte = getc(pk_file);
	bit_weight = 16;
    }
    temp = input_byte / bit_weight;
    input_byte -= temp*bit_weight;
    bit_weight /= 16;
    return(temp);
}


get_bit(pk_file)
FILE *pk_file;
{
int temp;
    bit_weight /= 2;
    if (bit_weight == 0) {
	input_byte = getc(pk_file);
	bit_weight = 128;
    }
    if (temp = (input_byte >= bit_weight))
	input_byte -= bit_weight;
    return(temp);
}
/* use this to check for bits set in a flag, (chars loaded, wanted, etc.) */
bit_set(char_no, flag_array)
int char_no, flag_array[];
{
	return((flag_array[char_no / word_size] >> (char_no % word_size)) & 1);
}
/* function to get the best local font available */
get_pk_name(finfo)
struct font *finfo;
{
#define my_max 100
#define last_chance "cmr10"
int poss_mags[my_max], i, best_match, no_to_try;

	if ((finfo->name[0] == 'a') && (finfo->name[1] == 'm'))
	    finfo->name[0] = 'c';	/* old fonts */

	/* lets first see if it's in the obvious spot */
#ifdef VAXC
	sprintf(finfo->local, "%s%d]%s.pk", font_dir, finfo->want_mag,
	    finfo->name);
#else
	sprintf(finfo->local, "%s/%d/%s.pk", font_dir, finfo->want_mag,
	    finfo->name);
#endif
	if (find_file(finfo->local)) return(1);

	/* what is available on the system ? */
	no_to_try = find_mags(poss_mags, my_max, font_dir, finfo->name);

	if (no_to_try <= 0) {
	    no_to_try = find_mags(poss_mags, my_max, font_dir, last_chance);
	    if (no_to_try > 0) {
		fprintf(stderr, "using %s for %s\n", last_chance, finfo->name);
		strcpy(finfo->name, last_chance);
	    }
	}

	if (no_to_try <= 0) {
	    fprintf(stderr, "no fonts at all !\n");
	    finfo->local[0] = '\0';
	    return(0);
	}

	best_match = find_best(finfo->want_mag, poss_mags, no_to_try);
#ifdef VAXC
	sprintf(finfo->local, "%s%d]%s.pk", font_dir, poss_mags[best_match],
	    finfo->name);
#else
	sprintf(finfo->local, "%s/%d/%s.pk", font_dir, poss_mags[best_match],
	    finfo->name);
#endif
	return(1);
}
/* use the pk routines to parse the relevant pk file and grab the characters */
do_pk_file(pk_file, finfo, dev_call, cell_call, capflag, need_rotate)
FILE *pk_file;
unsigned long capflag;	/* capability flag */
struct font *finfo;
int (*dev_call)(), (*cell_call)(), need_rotate;
{
int i, w_bytes, height, width, not_done, char_bytes;
unsigned char cmd, pl_length, flag, cc;
unsigned int k, j, pl, pl_start;
char *use_ptr, *process_char();

	if (!(pk_file = fopen(finfo->local, "r"))) return(0);

	read_pk_preamble(pk_file, &ds, &cs, &hppp, &vppp);

	/* now work our way thru the file */

	while (( (cmd = getc(pk_file)) != pk_post) && (finfo->used>0))
	switch (cmd) {

	case pk_xxx1:
	case pk_xxx2:
	case pk_xxx3:
	case pk_xxx4:
	    pkread(&k, cmd - pk_xxx1 + 1, 0, pk_file);
	    for (j=0; j<k; ++j) getc(pk_file);
	    break;

	case pk_yyy:
	    for (i=0; i<4; ++i) getc(pk_file);
	    break;

	/* these are presently undefined, may be used in future extensions */
	case 248:
	case 249:
	case 250:
	case 251:
	case 252:
	case 253:
	case 254:
	case 255:
	    fprintf(stderr, "\nnot ready for this command ! (%d)", cmd);
	    break;

/* now handle actual character descriptors */
	default:
	    flag = cmd;
	    switch (flag % 8){
	    case 0:
	    case 1:
	    case 2:
	    case 3:
		pl_start = (flag % 4) * shift8;
		pl_length = 1;
		break;

	    case 4:
	    case 5:
	    case 6:
		pl_start = (flag % 4) * shift16;
		pl_length = 2;
		break;

	    case 7:
		pl_start = 0;
		pl_length = 4;
		break;
	    }

	    pkread(&pl, pl_length, 0, pk_file);	/* packet length */
	    pl += pl_start;
	    cc = getc(pk_file);

/* now we actually process the character description */
/* in almost all cases we will want the description itself, if not (e.g., APS)
   then we will still want the TFM information */

	    if (bit_set(cc, finfo->want_flag)) {
		/* first we check to see if the device can do anything with
		   the character descriptions */
		if (dev_call) {	/* yes it can */

		    /* so get the info */
		    use_ptr = process_char(flag, pl, cc, need_rotate, 
			&w_bytes, &height,
			&width, &crec.tfm, &crec.pxl, pk_file,
		    	&h_dots, &v_dots, capflag & pad_rows);

		    /* and process it into device specific form */
		    char_bytes = (*dev_call)
			(use_ptr, w_bytes, height, width, cc, 
			crec.tfm, crec.pxl, crec.info, &crec.bytes,
		    	h_dots, v_dots);

		    /* now store it */
		    if (capflag & brk_ok)
			for (i=0; i < char_bytes; ++i) boutc(crec.info[i]);
		    else for (i=0; i < char_bytes; ++i) outc(crec.info[i]);

		} else 		/* no it can't */
		if (cell_call) { 

		    /* but can handle cell arrays, so get it padded */
		    use_ptr = process_char(flag, pl, cc, 0, 
			&w_bytes, &height,
			&width, &crec.tfm, &crec.pxl, pk_file,
		    	&h_dots, &v_dots, 1);

		    /* and store it away */
		    char_bytes = w_bytes * height;
		    finfo->ptr[cc] = char_stor_ptr;
		    for (i=0; i < char_bytes; ++i) 
			*char_stor_ptr++ = *(use_ptr + i);
		    finfo->no_bytes[cc] = char_bytes;
		} else {	/* can't do anything */

		    /* but still need the TFM info */
		    use_ptr = process_char(flag, pl, cc, 0, &w_bytes, &height,
			&width, &crec.tfm, &crec.pxl, pk_file,
		    	&h_dots, &v_dots, 0);

		}
		/* now fill out the internal info table */
		finfo->width[cc] = ( ((float) 
		    finfo->scale) * crec.tfm) / shift20;
		finfo->pxl[cc] = crec.pxl;
		finfo->voff[cc] = v_dots;
		finfo->hoff[cc] = h_dots;
		finfo->w_bytes[cc] = w_bytes;
		finfo->h_bits[cc] = height;
		finfo->w_bits[cc] = width;

		--finfo->used;	/* no longer need it */
		finfo->want_flag[cc / word_size]
		    &= ~(1 << ( cc % word_size));
	    }
	    else for (j=0; j<pl; ++j) getc(pk_file);
	    break;
	}
	fclose(pk_file);

	return(1);
}
/* now the CGM specific stuff */
/* just a callable routine to tell CGM what to expect */
ca_check(font_size)
int *font_size;
{

	*font_size =  (10 * base_pxl_per_in) / (pts_in * rfudge);

	return(CA_EMULATION);
}

/* text module for devices that need help */
/* set a text string as a series of cell arrays */
ca_text(x, y, instr, carray_call, a2, a5, no_chars,
capable, font_list, mag)
int x, y, (*carray_call)(), no_chars;
char *instr, *font_list;
long capable;
struct pic_d_struct *a2;	/* class 2 elements */
struct attrib_struct *a5;	/* class 5 elements */
double mag;
{
int p[2], q[2], r[2], i, j, char_no, loc_prec, new_size, old_size, str_height,
str_width, tot_size, ind, bw, bf, xdelta, ydelta, dl, have_char, x1, y1;
FILE *pk_file = NULL;
static char font_dir[max_str];
static char *cm_names[NO_FONTS] = {"cmr10", "cmitt10", "cmb10", "cmss10", 
"cmti10", "cmssbx10", "cmmib10", "cmtt10"}; /* must be in lower case ! */
static struct font cfarray[NO_FONTS];
static int no_to_try[NO_FONTS];
static int poss_mags[NO_FONTS][max_mags];

static int started_fonts = -1;	/* to show we haven't tried yet */
static int fonts_loaded = 0;	/* no of fonts we have loaded */
int want_mag, best_mag, best_index;
double ctheta1, ctheta2, stheta1, stheta2;
	if ((started_fonts < 0) && !(started_fonts = check_fdir(font_dir))) 
	    return(0);

	bw = capable & no_colour;	/* black and white device */
/* first check to see if we have the font we want */

	ind = (a5->t_f_index - 1) % NO_FONTS;
	if (no_to_try[ind] == 0)
	    no_to_try[ind] = find_mags(poss_mags[ind], max_mags, font_dir,
		cm_names[ind]);

	/* now decide the relevant font magnification */
	want_mag = mag * 1000;	/* TeX units */

	/* and see how close we can get */
	best_index = find_best(want_mag, poss_mags[ind], max_mags);
	best_mag = poss_mags[ind][best_index];

	/* now see if we have already loaded the best font */
	for (i=0; (i < fonts_loaded) && ((cfarray[i].want_mag != best_mag)
	    || (strcmp(cfarray[i].name, cm_names[ind]))); ++i);
	if ((i >= fonts_loaded) && (i < NO_FONTS)){ /* load new font */
	    cfarray[i].want_mag = best_mag;
	    strcpy(cfarray[i].name, cm_names[ind]);
	    for (j=0; j<flag_no; ++j) cfarray[i].want_flag[j] = ~0;
	    cfarray[i].used = max_chars;
#ifdef VAXC
	    sprintf(cfarray[i].local, "%s%d]%s.pk", font_dir, best_mag,
	    cm_names[ind]);
#else
	    sprintf(cfarray[i].local, "%s/%d/%s.pk", font_dir, best_mag,
	    cm_names[ind]);
#endif
	    if (do_pk_file(pk_file, &cfarray[i], NULL, 1, 0)) {
		fonts_loaded = i + 1;
		cfarray[i].found = 1;
		for (j=0; j<max_chars; ++j) {
		    cfarray[i].exp[j] = NULL;
	    	    cfarray[i].exp_size[j] = 0;
	    	    cfarray[i].exp_index[j] = 0;
		}
	    } else { 
		fprintf(stderr, "couldn't load %s\n", cfarray[i].local);
		cfarray[i].found = 0;
	    }
	}
	bf = i;	/* best font */

	/* get the string height and width */
	dim_str(&str_height, &str_width, &cfarray[bf], instr, no_chars, 
	    a5->text_path, a5->c_exp_fac, a5->c_space);

	/* now figure out the angle for the baseline etc of the string */
	/* first establish defaults */
	ctheta1 = stheta2 = 1.0;
	stheta1 = ctheta2 = 0.0;
	/* now make the calls */
	angle_str(&ctheta1, &stheta1, a5->c_orient.y_base,a5->c_orient.x_base); 
	angle_str(&ctheta2, &stheta2, a5->c_orient.y_up, a5->c_orient.x_up); 

	/* now get the offset we will need */
	get_offsets(&xdelta, &ydelta, ctheta1, stheta1, ctheta2, stheta2,
	    &(a5->text_align), str_height, str_width, a5->text_path);

	/* add in the offsets */
	x += xdelta;
	y += ydelta;
	/* now find our local precision */
	if (a2->c_s_mode == i_c_mode) {
	    if ((a5->text_colour.ind > 1) && (!bw)){	
		for (i=1; (i <= 32) && (a5->text_colour.ind >= (1 << i)); i *= 2);
		loc_prec = i;
		if (loc_prec > 32) {
		    fprintf(stderr, "trouble in ca_text, loc_prec = %d\n",
		    	loc_prec);
		    loc_prec = 32;
		}
		loc_prec = 8;	/* fix this */
	    } else loc_prec = 1;
	}
	else if (a2->c_s_mode == d_c_mode) {	/* direct */
	    /* implement later */
	}

	/* get the initial (small) offsets */
	xdelta = 0;
	ydelta = 0;
	switch (a5->text_path) {	/* fill in later */
	}
	/* go thru the string setting chars */
	for (i=0; i<no_chars; ++i) {
	    char_no = (int) *(instr + i) & 127;
	    /* do we have this character ? */
	    have_char = 
	       !((char_no < 0)	||	/* not printable */
		(char_no >= max_chars) ||
		(char_no == 32) ||			/* space */
		(cfarray[bf].w_bits[char_no] == 0) ||	/* no width */
		(cfarray[bf].h_bits[char_no] == 0));

	    /* now figure out how much we move */
	    /* first add in the character expansion factor and add. space */
	    xdelta = (int) (xdelta * a5->c_exp_fac) + a5->c_space;
	    /* now the geometric factors */
	    switch (a5->text_path) {
    case right :
		x1 = x += xdelta * ctheta1;
		y1 = y += xdelta * stheta1;
		break;
    case left :
		x -= xdelta * ctheta1;
		x1 = (have_char) ? 
		    x + 2 * cfarray[bf].hoff[char_no] 
			- cfarray[bf].pxl[char_no] * ctheta1 : 
		    x; 
		y1 = y -= xdelta * stheta1;
		break;
    case up :
		x += ydelta * ctheta2;
		x1 = (have_char) ? 
		    x - cfarray[bf].hoff[char_no] -
			ctheta1 * cfarray[bf].w_bits[char_no] / 2:
		    x;
		y += ydelta * stheta2;
		y1 = (have_char) ?
		    y + cfarray[bf].h_bits[char_no]+cfarray[bf].voff[char_no] * stheta2:
		    y;
		break;
    case down :
		x -= ydelta * ctheta2;
		x1 = (have_char) ?
		    x  - cfarray[bf].hoff[char_no] -
			 ctheta1 * cfarray[bf].w_bits[char_no] / 2:
		    x;
		y -= ydelta * stheta2;
		y1 = (have_char) ? 
		    y + cfarray[bf].voff[char_no] * stheta2:
		    y;
		break;
	    }
/* plot this character with a cell array */
	    if (have_char) {
		p[0] = x1 + cfarray[bf].hoff[char_no];
		p[1] = y1 - cfarray[bf].voff[char_no];
		q[0] = p[0] + cfarray[bf].w_bits[char_no] * ctheta1 * a5->c_exp_fac
		    - cfarray[bf].h_bits[char_no] * ctheta2;
		q[1] = p[1] + cfarray[bf].w_bits[char_no] * stheta1 * a5->c_exp_fac
		    - cfarray[bf].h_bits[char_no] * stheta2;
		r[0] = p[0] + cfarray[bf].w_bits[char_no] * ctheta1 * a5->c_exp_fac;
		r[1] = p[1] + cfarray[bf].w_bits[char_no] * stheta1 * a5->c_exp_fac;

		/* now may need to expand the cell array */

		if (a2->c_s_mode == i_c_mode) {
		    if ((a5->text_colour.ind > 1) && (!bw)) {
			new_size = (cfarray[bf].w_bits[char_no] * loc_prec + 
			    byte_size - 1) / byte_size;
			if (new_size % 2) ++new_size;
			old_size = (cfarray[bf].w_bits[char_no] + byte_size - 1) 
			    / byte_size;
			if (old_size % 2) ++old_size;
			tot_size = new_size * cfarray[bf].h_bits[char_no];
			if (cfarray[bf].exp_size[char_no] < tot_size) { 
			    if (cfarray[bf].exp[char_no] == NULL) 
				cfarray[bf].exp[char_no] = (unsigned char *)
				    allocate_mem(tot_size,1);
			    else cfarray[bf].exp[char_no] = (unsigned char *)
				realloc(cfarray[bf].exp[char_no], tot_size);
			    cfarray[bf].exp_size[char_no] = tot_size; 
			}
			if ( (cfarray[bf].exp_prec[char_no] != loc_prec) ||
			     (cfarray[bf].exp_index[char_no] != a5->text_colour.ind) ){
			    bit_col_carray(cfarray[bf].ptr[char_no], old_size, 
				cfarray[bf].w_bits[char_no], cfarray[bf].h_bits[char_no],
				cfarray[bf].exp[char_no], new_size, loc_prec, 
				a5->text_colour.ind, cfarray[bf].exp_index[char_no]);
			    cfarray[bf].exp_prec[char_no] = loc_prec;
			    cfarray[bf].exp_index[char_no] = a5->text_colour.ind;
			}
			(*carray_call) (p, q, r, 
			    cfarray[bf].w_bits[char_no], cfarray[bf].h_bits[char_no],
			    loc_prec, cfarray[bf].exp[char_no], 1);
		    }
		    else (*carray_call) (p, q, r, 
		    	cfarray[bf].w_bits[char_no], cfarray[bf].h_bits[char_no],
		    	1, cfarray[bf].ptr[char_no], 1);
		}
		else if (a2->c_s_mode == d_c_mode) { /* fix later */
		}
		xdelta = cfarray[bf].pxl[char_no];
		ydelta = cfarray[bf].h_bits[char_no];
	    } else {
		xdelta = (cfarray[bf].pxl[(int) 'm'] + 0.5) / 3.;
		ydelta = xdelta;
		have_char = 0;
	    }
	}
	return(1);
}
/* function to figure out string dimension */
static dim_str(ht, wd, finfo, instr, no_chars, path, exp_fac, c_space)
int *ht, *wd, no_chars;
struct font *finfo;
char *instr;
enum path_enum path;
float exp_fac, c_space;
{
int char_no, i, dw;

	*ht = 0;
	*wd = 0;
	    switch (path) {
case right:
case left:	
	    for (i=0; i < no_chars; ++i) {
	    	char_no = (int) *(instr + i) & 127;
	        if (*ht < finfo->h_bits[char_no])
		    *ht = finfo->h_bits[char_no];
	    	dw = (char_no == 32) ? (finfo->pxl[ (int) 'M'] + 1.5) / 3.
	    	    : finfo->pxl[char_no];
		*wd += (int) (dw * exp_fac) + c_space * dw;
	    }
	    break;
case up:
case down:
	    for (i=0; i < no_chars; ++i) {
	    	char_no = (int) *(instr + i) & 127;
	        if (*wd < finfo->pxl[char_no])
		    *wd = finfo->pxl[char_no];
	    	*ht += (char_no == 32) ? (finfo->h_bits[ (int) 'M'])
	    	    : finfo->h_bits[char_no];
	    }
	    break;
	}
	return(1);
}


