


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



/* $Header: /usr2/gcg/grap/src/lib/oogl/libpolylist/RCS/polylist.h,v 1.13 90/09/04 16:33:27 munzner Exp $ */
/* $Source: /usr2/gcg/grap/src/lib/oogl/libpolylist/RCS/polylist.h,v $ */


/*
 * Geometry Routines
 *
 * Geometry Supercomputer Project
 *
 * ROUTINE DESCRIPTION:
 * The header file for the polylist object
 */


#ifndef	POLYLISTDEFS
#define	POLYLISTDEFS

#include	"oogl/bbox.h"
#include	"geometry/point.h"
#include	"color/color.h"
#include        "oogl/geomclass.h"
#include        "oogl/geom.h"

/* TYPE DEFINITIONS */
typedef struct Vertex
{
	Point3	pt;
	ColorA	vcol;
	Point3	vn;
}  Vertex;

typedef struct Poly
{
	int	n_vertices;
	Vertex	**v;
	ColorA  pcol;
	Point3	pn;
}  Poly;

typedef struct PolyList
{
	int	n_polys;
	int	n_verts;
	Poly	*p;
	Vertex	*vl;
	int	flags;
#  define	  PL_HASVN	0x1	/* Per-vertex normals (vn) valid */
#  define	  PL_HASPN	0x2	/* Per-polygon normals (pn) valid */
#  define	  PL_HASVCOL	0x4	/* Per-vertex colors (vcol) valid */
#  define	  PL_HASPCOL	0x8	/* Per-polygon colors (pcol) valid */
#  define	  PL_EVNORM	0x10	/* Normals are everted */

}  PolyList;


extern PolyList *PolyListCreate();
extern PolyList *PolyListDraw( PolyList *poly, ContextObject *object_context );
extern PolyList *PolyListDrawIrisGl( PolyList *poly, ContextObject *object_context );
extern PolyList *PolyListDrawRenderman( PolyList *poly, ContextObject *object_context );
extern PolyList *PolyListDrawXWindows( PolyList *poly, ContextObject *object_context );
extern BBox	*PolyListBound();
extern PolyList *PolyListEvert();
extern PolyList *PolyListLoad();	/* Loads "off" files */
extern PolyList *PolyListFLoad();
extern char    *PolyListName();
extern PolyList *PolyListCopy( PolyList *poly );
extern PolyList *PolyListSave();
extern PolyList *PolyListFSave();
extern PolyList *PolyListDelete();


#ifdef GEOM_SM
extern GeomRef	PolyListShare( Geom *obj, GeomSMRegion *sm );
extern GeomRef	PolyListPrivate();
#endif /*GEOM_SM*/

#endif	POLYLISTDEFS
