/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	sep.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_separator class header
 *
 *	RCSid = "$Id: sep.H,v 4.6.1.1 1993/06/01 22:56:47 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_sep_H
#define OI_sep_H

#ifndef OI_wldtech_H
#include <OI/wldtech.H>
#endif /* OI_wldtech_H */

	// class forward reference declaration
	class OI_mdl_separator;

	class OI_separator : public OI_wl_d_tech {
			OI_mdl_separator	*mdl_dep ;				/* ptr to model dependent aspects of object */
			/**********************************************************************
			 * resources 
			 **********************************************************************/
			/**********************************************************************
			 * end of resources
			 **********************************************************************/
			OI_orient		ornt ;					/* orientation */
		public:
		static	OI_class		*clsp ;					/* ptr to class record */
		
		private:
			void			construct(OI_number, OI_orient=OI_HORIZONTAL) ;
			OI_stat			new_length(OI_number) ;
			void			res_orient(void *) ;
			void			res_length(void *);
		protected:
						OI_separator(OI_class *, const char *, OI_number, OI_orient=OI_HORIZONTAL) ;
		virtual	void			new_model(OI_model_type) ;
		public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_separator(const char*, OI_number, OI_orient=OI_HORIZONTAL);
						~OI_separator() ;
		static	OI_bool			init(OI_connection*) ;
		virtual	OI_bool			is_write_resq(XrmQuark);
		static	OI_separator		*make_minimal(const char*,OI_minimal_type) ;
		virtual	void			min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
		virtual	void			nominal_outside_size(OI_number*,OI_number*);
			void			new_orientation(OI_orient) ;
		virtual	void			paint(const XEvent*, void* =NULL) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void			clone_adjust(OI_d_tech*) ;
		virtual	OI_bool			is_acceptable_child(OI_d_tech*) ;		/* chk if object is suitable as child */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_number		length() ;
			OI_orient		orientation()		{ return(ornt); }
			OI_stat			set_length(OI_number) ;
			void			set_orientation(OI_orient) ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_separator	*oi_create_separator(const char*, OI_number, OI_orient=OI_HORIZONTAL) ;

#endif /* OI_sep_H */
