/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	objloc.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Object locator class header
 *
 *	RCSid = "$Id: objloc.H,v 1.3.1.1 1993/06/01 22:55:49 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_objloc_H
#define OI_objloc_H

#ifndef NamTbl_H
#include <OI/NamTbl.H>
#endif /* NamTbl_H */

#ifndef OI_cb_inf_H
#include <OI/cb_inf.H>
#endif /* OI_cb_inf_H */

	class	OI_obj_locate_cb;

	typedef	CommonBase*		(*OI_obj_locator_fnp)(const char*) ;
	typedef	CommonBase*		(CommonBase::*OI_obj_locator_memfnp)(const char*) ;

#define		OI_default_CommonBaseNameId_generator	((OI_id_generator_fnp)XrmStringToQuark)
#define		OI_default_CommonBaseNameId_convertor	((OI_id_convertor_fnp)XrmQuarkToString)

		class	OI_obj_locator : public CommonBase	{
			OI_obj_locate_cb	*tblp;					// list of locator callbacks
		 private:
			void			add_cb(const char*, OI_obj_locator_fnp, CommonBase*, OI_obj_locator_memfnp,
							OI_id_generator_fnp, CommonBase*, OI_id_generator_memfnp);
			void			remove_cb(const char*, OI_obj_locator_fnp, CommonBase*, OI_obj_locator_memfnp);
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_obj_locator();
		virtual				~OI_obj_locator();
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			add(const char*, OI_obj_locator_fnp, OI_id_generator_fnp);
			void			add(const char*, OI_obj_locator_fnp, CommonBase*, OI_id_generator_memfnp);
			void			add(const char*, CommonBase*, OI_obj_locator_memfnp, OI_id_generator_fnp);
			void			add(const char*, CommonBase*, OI_obj_locator_memfnp, CommonBase*, OI_id_generator_memfnp);
			CommonBase		*locate(const char*, const char*);			// locate an object
			CommonBase		*locate(XrmQuark, const char*);				// locate an object
			void			remove(const char*, OI_obj_locator_fnp);
			void			remove(const char*, CommonBase*, OI_obj_locator_memfnp);
		} ;

		class OI_obj_locate_cb : public OI_cb {				// callback to locate an object
			OI_obj_locate_cb	*nxtp ;				// link to next callback, NULL => end of list
			XrmQuark		q ;				// Quark for name used to activate locate function
			OI_id_generator_fnp	id_fp ;				// ptr to function to generate id from name
			CommonBase		*id_objp ;			// ptr to object for id_mfp
			OI_id_generator_memfnp	id_mfp ;			// ptr to function to generate id from name
		 private:
			void			set_name_generator(OI_id_generator_fnp, CommonBase*, OI_id_generator_memfnp);
		 public:
						OI_obj_locate_cb(const char*, OI_obj_locator_fnp, CommonBase*, OI_obj_locator_memfnp);
		virtual				~OI_obj_locate_cb();
			CommonBaseNameId	generate_id(const char*);
			OI_obj_locate_cb	*next()				{ return(nxtp); }
			XrmQuark		quark()				{ return(q); }
			void			set_name_generator(OI_id_generator_fnp fp)
							{ set_name_generator(fp,NULL,NULL); }
			void			set_name_generator(CommonBase *op, OI_id_generator_memfnp mfp)
							{ set_name_generator(NULL,op,mfp); }
			void			set_next(OI_obj_locate_cb *p)	{ nxtp=p; }
		} ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_objloc_H */
