/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	mrkr.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_marker class header
 *
 *	RCSid = "$Id: mrkr.H,v 4.3.1.1 1993/06/01 22:55:43 mth Exp $"
 *
 ****************************************************************************
 */
#ifndef OI_mrkr_H
#define OI_mrkr_H

	class OI_d_tech;

#define	OI_marker_space		2
#define	OI_MARKER_LENGTH	6
#define	OI_MARKER_WIDTH		2
#define	OI_MARKER_BEVEL_WIDTH	1

	class OI_marker {
			/**********************************************************************
			 * resources 
			 **********************************************************************/
			/**********************************************************************
			 * end of resources
			 **********************************************************************/
			OI_orient		ornt ;		/* orientation */
			OI_position		arrg;		/* Position of label with respect to tick. */
			OI_number		tck_wid;	/* Tick width. */
			OI_number		tck_len;	/* Tick size along major axis. */
			OI_string		*lab_str;	/* Label info for marker. */
			OI_number		sp;		/* Space between tick and label.*/
			OI_number		bvl_wid;	/* Bevel width of the tick. */
			OI_xy			siz;		/* Marker width and height. */
		public:
		
		private:
			void			construct(OI_orient, OI_number, OI_number, const char *, OI_font_bounds*, OI_char_encode_type,
							OI_position, OI_number =OI_MARKER_BEVEL_WIDTH);
		public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_marker(OI_orient, OI_number, OI_number, const char *, OI_font_bounds  *,
							OI_char_encode_type =OI_char_encode_none, OI_position=OI_default_position,
							OI_number =OI_MARKER_BEVEL_WIDTH);
						OI_marker(const char * =NULL, OI_font_bounds  * =NULL, OI_char_encode_type =OI_char_encode_none);
						/* This version of OI_marker provided for dpy_1d where only label related parameters are known */
						~OI_marker() ;
			void			paint_marker(OI_d_tech *, OI_number, OI_number, OI_bool=OI_YES, OI_bool=OI_YES);
			void			paint_tick_mark(OI_d_tech *, OI_number, OI_number);
			void			paint_tick_label(OI_d_tech *, OI_number, OI_number);
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
//			char*			label() 		{return(lab);}
			OI_number		major_size() 		{return(tck_len);}
			OI_position		arrangement() 		{return(arrg);}
			OI_number		marker_space() 		{return(sp);}
			OI_number		minor_size() 		{return(tck_wid);}
			OI_orient		orientation()		{ return(ornt); }
			OI_number		size_x()		{return(siz.x);}
			OI_number		size_y()		{return(siz.y);}
			OI_string		*label()		{return(lab_str);}

			OI_stat			change_arrangement(OI_position, OI_bool=OI_YES);
			OI_stat			set_label(const char* =NULL, OI_font_bounds * =NULL, OI_bool=OI_YES);
			OI_stat			set_label(OI_string*, OI_bool=OI_YES);
			OI_stat			set_marker_space(OI_number, OI_bool=OI_YES);
			OI_stat			set_orientation(OI_orient, OI_bool=OI_YES);
			OI_stat			set_tick_length(OI_number, OI_bool=OI_YES) ;
			OI_stat			set_tick_width(OI_number, OI_bool=OI_YES) ;
			void			set_font(const char *,OI_charset cs=OI_charset_latin1, OI_bool=OI_YES);
			void			set_bevel_width(OI_number, OI_bool=OI_YES) ;

			void			layout_marker(OI_number * =NULL, OI_number* =NULL);
			void			label_origin(OI_number *, OI_number*);
			void			tick_origin(OI_number *, OI_number*);
			void			label_size(OI_number *, OI_number*);
			OI_number		horizontal_extent()	{return(siz.x);}
			OI_number		vertical_extent()	{return(siz.y);}
			OI_number		right_extent();
			OI_number		left_extent();
			OI_number		top_extent();
			OI_number		bottom_extent();
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_mrkr_H */
