#include <OI/oi.H>			/* SeqHex.C */
#include <stdlib.h>
int main( int	argc, char** argv)
{
	OI_ef_sequence_status	inc_hex(OI_seq_entry_field*,void*,OI_ef_sequence_status);
	OI_ef_sequence_status	dec_hex(OI_seq_entry_field*,void*,OI_ef_sequence_status);
	OI_ef_char_chk_status		validate_hex(OI_entry_field*,void*,OI_ef_char_chk_status,OI_number,char);

	OI_connection	*conp;
	OI_app_window	*wp;
	OI_seq_entry_field	*sep;
	
	if (conp = OI_init(&argc,argv,"SeqHex")) {
		wp = oi_create_app_window("main_window",1,1,"Hex Demo");
		wp->set_layout(OI_layout_row);
		sep = oi_create_seq_entry_field("hex",7,"Hex Integer: ","0");
		sep->layout_associated_object(wp,1,1,OI_active);
		sep->set_char_check(validate_hex);
		sep->set_increment(inc_hex);
		sep->set_decrement(dec_hex);
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
		OI_fini();
	}
}
OI_ef_char_chk_status validate_hex(OI_entry_field*,void*,OI_ef_char_chk_status stat,OI_number psn,char c)
{
	OI_ef_char_chk_status	ret_val;

	ret_val = OI_ef_char_chk_bad;
	if (stat == OI_ef_char_chk_insert) {
		if (psn >= 0) {
			if (isxdigit(c))
				ret_val = OI_ef_char_chk_insert;
		}
		else
			ret_val = OI_ef_char_chk_insert;
	}
	return (ret_val);
}
OI_ef_sequence_status inc_hex(OI_seq_entry_field *sep, void*, OI_ef_sequence_status stat)
{
	long	nbr;
	char	string[10];

	if (stat == OI_ef_sequence_ok) {
		if (sep->part_text() == NULL)
			sep->set_text("0",OI_no);
		nbr = strtol(sep->part_text(),NULL,16);
		nbr++;
		sprintf(string,"%x",nbr);
		sep->set_text(string,OI_no);
	}
	return(stat);
}
OI_ef_sequence_status dec_hex(OI_seq_entry_field *sep, void*, OI_ef_sequence_status stat)
{
	long	nbr;
	char	string[10];

	if (stat == OI_ef_sequence_ok) {
		if (sep->part_text() == NULL)
			sep->set_text("0",OI_no);
		nbr = strtol(sep->part_text(),NULL,16);
		if (nbr)
			nbr--;
		sprintf(string,"%x",nbr);
		sep->set_text(string,OI_no);
	}
	return(stat);
}
