#include <OI/oi.H>		/* MenuBox.C */

void callback0(OI_menu_cell *objp, void*, OI_number)
{
	OI_menu		*mnup;
	OI_menu_cell	**cells;
	int		i;

	mnup = (OI_menu*)objp->parent();
	if (cells = mnup->multi_selected()) {
		for (i=0 ; cells[i] ; i++)
			fprintf(stderr, "%s\n",cells[i]->full_name());
	}
	return;
}

int main (int argc, char** argv)
{
		OI_connection	*conp;
		OI_app_window	*wp;
		OI_menu_box	*mnubox;
		OI_menu		*menu;
	static	OI_cell_spec	btn_cells[] = {
			{"btn_cell0","Button Menu Cell 0", callback0},
			{"btn_cell1","Button Menu Cell 1", callback0},
			{"btn_cell2","Button Menu Cell 2", callback0},
			};
	static	OI_cell_spec	excl_cells[] = {
			{"excl_cell0","Excl Menu Cell 0", callback0},
			{"excl_cell1","Excl Menu Cell 1", callback0},
			{"excl_cell2","Excl Menu Cell 2", callback0},
			};
	static	OI_cell_spec	poly_cells[] = {
			{"poly_cell0","Poly Menu Cell 0", callback0},
			{"poly_cell1","Poly Menu Cell 1", callback0},
			{"poly_cell2","Poly Menu Cell 2", callback0},
			};

	if (conp = OI_init(&argc, argv, "MenuBox", "MenuBox")) {
		wp = oi_create_app_window("app_window",1,1,"MenuBox");
		wp->set_layout(OI_layout_row);
		mnubox = oi_create_menu_box("mnubox", "MenuBox Title");
		mnubox->set_layout(OI_layout_row);
		menu = oi_create_button_menu("button_menu", OI_n_cells(btn_cells), btn_cells, OI_vertical);
		menu->layout_associated_object(mnubox, (OI_number)0, 0, OI_active);
		menu = oi_create_excl_check_menu("excl_check_menu", OI_n_cells(excl_cells), excl_cells, OI_vertical);
		menu->layout_associated_object(mnubox, (OI_number)0, 1, OI_active);
		menu = oi_create_poly_check_menu("poly_check_menu", OI_n_cells(poly_cells), poly_cells, OI_vertical);
		menu->layout_associated_object(mnubox, (OI_number)0, 2, OI_active);
		mnubox->layout_associated_object(wp, 10, 10, OI_active);
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
		OI_fini();
	}
}
