#include <OI/oi.H>			/* AutoLS.C */
int main (int argc, char** argv)
{
		void	build_n_fork(OI_menu_cell*,void*,OI_number);

		OI_connection		*conp;
		OI_app_window		*wp;
		OI_button_menu		*bmp;
		OI_poly_check_menu	*pcmp;
		OI_menu_cell		*cellp;
	static	OI_cell_spec	ls_exit[] = {
		{"dir","ls",build_n_fork},
		{"exit","exit",(OI_action_fnp)OI_end_interaction},
		};
	static	OI_cell_spec	optns[] = {
		{"-c","-c  Sort by time of last edit"},
		{"-i","-i  Print i-number"},
		{"-l","-l  List in long format"},
		{"-r","-r  Reverse order of sort"},
		{"-u","-u  Sort by time of last access"},
		{"-1","-1  One entry per line output"},
		};
	
	if (conp = OI_init(&argc,argv,"AutoLS")) {
		wp = oi_create_app_window("main",1,1,"Auto ls");
		wp->set_layout(OI_layout_row);
		bmp = oi_create_button_menu("ls",OI_count(ls_exit),&ls_exit[0],OI_horizontal);
		wp->set_main_menu(bmp);
		pcmp = oi_create_poly_check_menu("ls_options",OI_count(optns),&optns[0],OI_vertical);
		pcmp->layout_associated_object(wp,1,2,OI_active);
		pcmp->allow_user_arg();		// mark menu for form_cmd arguments
		cellp = ((OI_menu_cell*)(bmp->subobject("dir")));
		cellp->change_arg(pcmp);	// send ptr to "ls_options" to callback
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
		OI_fini();
	}
}

void build_n_fork(OI_menu_cell*,void *argp, OI_number)
{
		OI_d_tech	*dtp;

	dtp = (OI_d_tech*)argp;
	OI_fork(dtp->form_cmd("ls $1"));	// build ls command from menu cell names
	return;					// and fork it
}
