#include <OI/oi.H>

/*
 *	Hello World
 *
 *	This very simple program was created to introduce the programmer
 *	to the OI library.  This program simply creates an application
 *	window, and static text within that application window, then 
 *	presents both to the user.
 *
 *	This program demonstrates the basic form of all OI programs:
 *		OI_init			- initialize OI and open a connection
 *		OI_create_app_window	- create the main application window
 *		>> 
 *		>>	build forest of objects within the application window
 *		>>
 *		OI_begin_interaction	- begin interaction with the user
 *		OI_fini			- clean up
 *
 *	To the novice user, OI documentation can be quite daunting.  The proper
 *	way to approach the documentation is to understand the following basic
 *	concepts:
 *		1. The OI library is constructed by building (or subclassing)
 *			objects off of other objects.  The base object is
 *			called OI_d_tech.  As one example, the OI_seq_entry_field 
 *			object is derived from the OI_entry_field object, which in
 *			turn is derived from the OI_d_tech object:
 *				OI_d_tech
 *					OI_entry_field
 *						OI_seq_entry_field.
 *		2. To look for information about a specific object, start by
 *			looking through the man page for that object.  Immediately
 *			under the FUNCTIONS heading will be information concerning
 *			how this object has been derived.  This information lets 
 *			you know where to search for additional information about
 *			the object.
 *		3. Additional man pages exist for the following subjects:
 *			OIIntro
 *			OI_translations and accelerators
 *			OI_resources
 *			OI_connection - Xwindow connection information.
 *
 *	The reader should refer to the OI documentation for
 *	information on the following member functions.
 *		- OIIntro
 *			OI_init()
 *			OI_begin_interaction()
 *			OI_fini()
 *		- OI_d_tech
 *			set_associated_object()
 *		- OI_app_window
 *			oi_create_app_window()
 *		- OI_static_text
 *			oi_create_static_text()
 */
void
main (int argc, char**argv)
{
	OI_connection	*conp ;
	OI_app_window	*wp ;
	OI_static_text	*tp ;

	
	//
	//	Open a connection.
	//
	if (conp = OI_init(&argc, argv, "HelloWorld")) {
		//
		//	create the application window.
		//
		wp = oi_create_app_window("main",200,100,"Main Window") ;
		//
		//	create the static text.
		//
		tp = oi_create_static_text("text","Hello, World!") ;
		//
		//	associate the static text with the application window.
		//
		tp->set_associated_object(wp,10,10,OI_ACTIVE) ;
		//
		//	display main window.
		//
		wp->set_associated_object(wp->root(), OI_DEF_LOC, OI_DEF_LOC, OI_ACTIVE) ;
		//
		//	begin interaction
		//
		OI_begin_interaction() ;
	}

	//
	//	Cleanup.  Make sure that we cleanup the library.
	//
	OI_fini() ;
}
