/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.BeanIntrospector;
import org.cojen.util.BeanProperty;
import org.cojen.util.ClassInjector;
import org.cojen.util.NoSuchPropertyException;
import org.cojen.util.WeakIdentityMap;

public abstract class BeanPropertyAccessor {
    private static Map cAccessors = new WeakIdentityMap();
    static /* synthetic */ Class class$org$cojen$util$BeanPropertyAccessor;
    static /* synthetic */ Class class$org$cojen$util$NoSuchPropertyException;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanPropertyAccessor forClass(Class clazz) {
        Map map = cAccessors;
        synchronized (map) {
            BeanPropertyAccessor bpa;
            SoftReference ref = (SoftReference)cAccessors.get(clazz);
            if (ref != null && (bpa = (BeanPropertyAccessor)ref.get()) != null) {
                return bpa;
            }
            bpa = BeanPropertyAccessor.generate(clazz);
            cAccessors.put(clazz, new SoftReference<BeanPropertyAccessor>(bpa));
            return bpa;
        }
    }

    private static BeanPropertyAccessor generate(Class beanType) {
        ClassInjector ci = ClassInjector.create((class$org$cojen$util$BeanPropertyAccessor == null ? (class$org$cojen$util$BeanPropertyAccessor = BeanPropertyAccessor.class$("org.cojen.util.BeanPropertyAccessor")) : class$org$cojen$util$BeanPropertyAccessor).getName(), beanType.getClassLoader());
        Class clazz = ci.defineClass(BeanPropertyAccessor.generateClassFile(ci.getClassName(), beanType));
        try {
            return (BeanPropertyAccessor)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new InternalError(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
    }

    private static ClassFile generateClassFile(String className, Class beanType) {
        BeanProperty[][] props = BeanPropertyAccessor.getBeanProperties(beanType);
        ClassFile cf = new ClassFile(className, class$org$cojen$util$BeanPropertyAccessor == null ? (class$org$cojen$util$BeanPropertyAccessor = BeanPropertyAccessor.class$("org.cojen.util.BeanPropertyAccessor")) : class$org$cojen$util$BeanPropertyAccessor);
        cf.markSynthetic();
        cf.setSourceFile((class$org$cojen$util$BeanPropertyAccessor == null ? (class$org$cojen$util$BeanPropertyAccessor = BeanPropertyAccessor.class$("org.cojen.util.BeanPropertyAccessor")) : class$org$cojen$util$BeanPropertyAccessor).getName());
        try {
            cf.setTarget(System.getProperty("java.specification.version"));
        }
        catch (Exception e) {
            // empty catch block
        }
        MethodInfo ctor = cf.addConstructor(Modifiers.PUBLIC, null);
        ctor.markSynthetic();
        CodeBuilder builder = new CodeBuilder(ctor);
        builder.loadThis();
        builder.invokeSuperConstructor(null);
        builder.returnVoid();
        BeanPropertyAccessor.generateMethod(cf, beanType, props[0], true);
        BeanPropertyAccessor.generateMethod(cf, beanType, props[1], false);
        return cf;
    }

    private static void generateMethod(ClassFile cf, Class beanType, BeanProperty[] properties, boolean forRead) {
        MethodInfo mi;
        TypeDesc[] params;
        TypeDesc objectType = TypeDesc.OBJECT;
        TypeDesc stringType = TypeDesc.STRING;
        TypeDesc intType = TypeDesc.INT;
        TypeDesc booleanType = TypeDesc.BOOLEAN;
        TypeDesc exceptionType = TypeDesc.forClass(class$org$cojen$util$NoSuchPropertyException == null ? (class$org$cojen$util$NoSuchPropertyException = BeanPropertyAccessor.class$("org.cojen.util.NoSuchPropertyException")) : class$org$cojen$util$NoSuchPropertyException);
        if (forRead) {
            params = new TypeDesc[]{objectType, stringType};
            mi = cf.addMethod(Modifiers.PUBLIC, "getPropertyValue", objectType, params);
        } else {
            params = new TypeDesc[]{objectType, stringType, objectType};
            mi = cf.addMethod(Modifiers.PUBLIC, "setPropertyValue", null, params);
        }
        mi.markSynthetic();
        CodeBuilder builder = new CodeBuilder(mi);
        LocalVariable beanVar = builder.getParameter(0);
        LocalVariable propertyVar = builder.getParameter(1);
        LocalVariable valueVar = forRead ? null : builder.getParameter(2);
        builder.loadLocal(beanVar);
        builder.checkCast(TypeDesc.forClass(beanType));
        builder.storeLocal(beanVar);
        if (properties.length > 0) {
            int[] cases = new int[BeanPropertyAccessor.hashCapacity(properties.length)];
            int caseCount = cases.length;
            for (int i = 0; i < caseCount; ++i) {
                cases[i] = i;
            }
            Location[] switchLabels = new Label[caseCount];
            Label noMatch = builder.createLabel();
            List[] caseMethods = BeanPropertyAccessor.caseMethods(caseCount, properties);
            for (int i = 0; i < caseCount; ++i) {
                List matches = caseMethods[i];
                switchLabels[i] = matches == null || matches.size() == 0 ? noMatch : builder.createLabel();
            }
            if (properties.length > 1) {
                builder.loadLocal(propertyVar);
                builder.invokeVirtual((class$java$lang$String == null ? (class$java$lang$String = BeanPropertyAccessor.class$("java.lang.String")) : class$java$lang$String).getName(), "hashCode", intType, null);
                builder.loadConstant(Integer.MAX_VALUE);
                builder.math((byte)126);
                builder.loadConstant(caseCount);
                builder.math((byte)112);
                builder.switchBranch(cases, switchLabels, noMatch);
            }
            TypeDesc[] params2 = new TypeDesc[]{objectType};
            for (int i = 0; i < caseCount; ++i) {
                List matches = caseMethods[i];
                if (matches == null || matches.size() == 0) continue;
                switchLabels[i].setLocation();
                int matchCount = matches.size();
                for (int j = 0; j < matchCount; ++j) {
                    TypeDesc type;
                    Label notEqual;
                    BeanProperty bp = (BeanProperty)matches.get(j);
                    builder.loadConstant(bp.getName());
                    builder.loadLocal(propertyVar);
                    builder.invokeVirtual((class$java$lang$String == null ? BeanPropertyAccessor.class$("java.lang.String") : class$java$lang$String).getName(), "equals", booleanType, params2);
                    if (j == matchCount - 1) {
                        notEqual = null;
                        builder.ifZeroComparisonBranch(noMatch, "==");
                    } else {
                        notEqual = builder.createLabel();
                        builder.ifZeroComparisonBranch(notEqual, "==");
                    }
                    if (forRead) {
                        builder.loadLocal(beanVar);
                        builder.invoke(bp.getReadMethod());
                        type = TypeDesc.forClass(bp.getType());
                        builder.convert(type, type.toObjectType());
                        builder.returnValue(TypeDesc.OBJECT);
                    } else {
                        builder.loadLocal(beanVar);
                        builder.loadLocal(valueVar);
                        type = TypeDesc.forClass(bp.getType());
                        builder.checkCast(type.toObjectType());
                        builder.convert(type.toObjectType(), type);
                        builder.invoke(bp.getWriteMethod());
                        builder.returnVoid();
                    }
                    if (notEqual == null) continue;
                    notEqual.setLocation();
                }
            }
            noMatch.setLocation();
        }
        builder.newObject(exceptionType);
        builder.dup();
        builder.loadLocal(propertyVar);
        builder.loadConstant(forRead);
        TypeDesc[] params3 = new TypeDesc[]{stringType, booleanType};
        builder.invokeConstructor((class$org$cojen$util$NoSuchPropertyException == null ? (class$org$cojen$util$NoSuchPropertyException = BeanPropertyAccessor.class$("org.cojen.util.NoSuchPropertyException")) : class$org$cojen$util$NoSuchPropertyException).getName(), params3);
        builder.throwObject();
    }

    private static int hashCapacity(int min) {
        BigInteger capacity = BigInteger.valueOf(min * 2 + 1);
        while (!capacity.isProbablePrime(100)) {
            capacity = capacity.add(BigInteger.valueOf(2L));
        }
        return capacity.intValue();
    }

    private static List[] caseMethods(int caseCount, BeanProperty[] props) {
        List[] cases = new List[caseCount];
        for (int i = 0; i < props.length; ++i) {
            BeanProperty prop = props[i];
            int hashCode = prop.getName().hashCode();
            int caseValue = (hashCode & Integer.MAX_VALUE) % caseCount;
            ArrayList<BeanProperty> matches = cases[caseValue];
            if (matches == null) {
                matches = cases[caseValue] = new ArrayList<BeanProperty>();
            }
            matches.add(prop);
        }
        return cases;
    }

    private static BeanProperty[][] getBeanProperties(Class beanType) {
        ArrayList<BeanProperty> readProperties = new ArrayList<BeanProperty>();
        ArrayList<BeanProperty> writeProperties = new ArrayList<BeanProperty>();
        Map map = BeanIntrospector.getAllProperties(beanType);
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            BeanProperty bp = (BeanProperty)it.next();
            if (bp.getReadMethod() != null) {
                readProperties.add(bp);
            }
            if (bp.getWriteMethod() == null) continue;
            writeProperties.add(bp);
        }
        BeanProperty[][] props = new BeanProperty[2][];
        props[0] = new BeanProperty[readProperties.size()];
        readProperties.toArray(props[0]);
        props[1] = new BeanProperty[writeProperties.size()];
        writeProperties.toArray(props[1]);
        return props;
    }

    protected BeanPropertyAccessor() {
    }

    public abstract Object getPropertyValue(Object var1, String var2) throws NoSuchPropertyException;

    public abstract void setPropertyValue(Object var1, String var2, Object var3) throws NoSuchPropertyException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

