/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.util;

import alt.jiapi.InstrumentationContext;
import alt.jiapi.util.InstrumentingClassLoader;
import java.lang.reflect.Method;

public class Bootstrapper {
    public Bootstrapper(String className, String methodName, Class[] parameterTypes, Object[] args, ClassLoader classLoader) {
        this.bootstrap(className, methodName, parameterTypes, args, classLoader);
    }

    public void bootstrap(String className, String methodName, Class[] parameterTypes, Object[] args, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            Method method = clazz.getMethod(methodName, parameterTypes);
            Object obj = clazz.newInstance();
            method.invoke(obj, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void launch(String className, Object[] args, InstrumentationContext ctx, ClassLoader classLoader) {
        Class[] types = new Class[]{String[].class};
        Bootstrapper.launch(className, "main", types, args, ctx, classLoader);
    }

    public static void launch(String className, String methodName, Class[] parameterTypes, Object[] args, InstrumentationContext ctx, ClassLoader classLoader) {
        try {
            Method setContext = classLoader.getClass().getMethod("setContext", ctx.getClass());
            setContext.invoke((Object)classLoader, ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("\n" + e.getClass() + ": " + e.getMessage());
            System.err.println("\nYou are propably trying to launch an application without properly bootstrapping it. A recommended way is to use utility alt.jiapi.util.Bootstrapper. At your shell prompt say:\njava alt.jiapi.util.Bootstrapper org.your.App [params]\nThat will launch your application so that the classes needed for instrumentation are loaded to a same namespace. There's also a script which can be used for bootstrapping:\njiapi.sh org.your.App [params]\n\n");
            return;
        }
        try {
            Class<?> clazz = classLoader.loadClass(className);
            Method method = clazz.getMethod(methodName, parameterTypes);
            if (args == null) {
                args = new String[]{};
            }
            method.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Object[] _args = new String[args.length - 1];
        System.arraycopy(args, 1, _args, 0, _args.length);
        ClassLoader classLoader = InstrumentingClassLoader.createClassLoader();
        Class[] types = new Class[]{_args.getClass()};
        new Bootstrapper(args[0], "main", types, _args, classLoader);
    }
}

