# https://github.com/google/dagger/blob/master/util/generate-latest-docs.sh

set -eu

if [ "$TRAVIS_REPO_SLUG" == "google/error-prone" ] && \
   [ "$TRAVIS_JDK_VERSION" == "oraclejdk8" ] && \
   [ "$TRAVIS_PULL_REQUEST" == "false" ] && \
   [ "$TRAVIS_BRANCH" == "master" ]; then
  echo -e "Publishing docs...\n"

  GH_PAGES_DIR=$HOME/gh-pages

  git clone --quiet --branch=gh-pages https://${GH_TOKEN}@github.com/google/error-prone $GH_PAGES_DIR > /dev/null
  (
    cd $GH_PAGES_DIR
    rm -rf _data/bugpatterns.yaml api/latest
    mkdir -p _data api/latest
  )

  mvn -P '!examples' javadoc:aggregate
  rsync -a target/site/apidocs/ ${GH_PAGES_DIR}/api/latest

  # The "mvn clean" is necessary since the wiki docs are generated by an
  # annotation processor that also compiles the code.  If Maven thinks the code
  # does not need to be recompiled, the wiki docs will not be generated either.
  mvn clean

  mvn -P run-annotation-processor compile site
  rsync -a docgen/target/generated-wiki/ ${GH_PAGES_DIR}

  cd $GH_PAGES_DIR
  git add --all .
  git config --global user.name "travis-ci"
  git config --global user.email "travis@travis-ci.org"
  git commit -m "Latest docs on successful travis build $TRAVIS_BUILD_NUMBER auto-pushed to gh-pages"
  git push -fq origin gh-pages > /dev/null

  echo -e "Published docs to gh-pages.\n"
fi
