/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.IOException;
import javax.servlet.ServletException;
import junit.framework.TestCase;
import org.tuckey.web.MockRequest;
import org.tuckey.web.MockResponse;
import org.tuckey.web.filters.urlrewrite.Condition;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.Rule;
import org.tuckey.web.filters.urlrewrite.SetAttribute;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class RuleTest
extends TestCase {
    MockResponse response;
    MockRequest request;

    public void setUp() {
        Log.setLevel("TRACE");
        this.response = new MockResponse();
        this.request = new MockRequest();
    }

    public void testRule01() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("simple(ass)");
        rule.setTo("$1simple");
        rule.initialise(null);
        MockRequest request = new MockRequest("simpleass");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"forward should be default type", (String)"forward", (String)rule.getToType());
        RuleTest.assertEquals((String)"asssimple", (String)rewrittenUrl.getTarget());
        RuleTest.assertTrue((String)"Should be a forward", (boolean)rewrittenUrl.isForward());
    }

    public void testRuleNullTo() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("null");
        rule.initialise(null);
        SetAttribute setAttribute1 = new SetAttribute();
        setAttribute1.setType("status");
        setAttribute1.setValue("302");
        rule.addSetAttribute(setAttribute1);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((int)302, (int)this.response.getStatus());
        RuleTest.assertTrue((boolean)rewrittenUrl.isStopFilterChain());
    }

    public void testRuleInclude() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("to");
        rule.setToType("pre-include");
        rule.initialise(null);
        this.request.setRequestURI("from");
        RewrittenUrl rewrittenUrl = rule.execute(this.request.getRequestURI(), this.request, this.response);
        RuleTest.assertEquals((String)"pre-include", (String)rule.getToType());
        RuleTest.assertTrue((String)"Should be an pre include", (boolean)rewrittenUrl.isPreInclude());
    }

    public void testRuleBackRef() throws IOException, ServletException {
        Condition c = new Condition();
        c.setName("hdr");
        c.setValue("aaa([a-z]+)cc(c)");
        Rule rule = new Rule();
        rule.setFrom("([a-z])rom");
        rule.setTo("from match: $1, backref1: %1, backref2: %2, bad backref: %a % %99 %%88, escaped backref: \\%2");
        rule.addCondition(c);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        request.setHeader("hdr", "aaafffccc");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"Should have replaced back reference", (String)"from match: f, backref1: fff, backref2: c, bad backref: %a % 9 %8, escaped backref: %2", (String)rewrittenUrl.getTarget());
        RuleTest.assertTrue((boolean)rule.isToContainsBackReference());
        RuleTest.assertFalse((boolean)rule.isToContainsVariable());
    }

    public void testRuleBackRefHost() throws IOException, ServletException {
        Condition c = new Condition();
        c.setType("server-name");
        c.setValue("^([^.]+)\\.domain\\.com");
        Rule rule = new Rule();
        rule.setFrom("^/(.*)");
        rule.setTo("/%1/$1");
        rule.setToType("redirect");
        rule.setToLast("true");
        rule.addCondition(c);
        rule.initialise(null);
        MockRequest request = new MockRequest("/from");
        request.setServerName("server.domain.com");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"Should have replaced back reference", (String)"/server/from", (String)rewrittenUrl.getTarget());
        RuleTest.assertTrue((boolean)rule.isToContainsBackReference());
    }

    public void testRuleBackRefMixed() throws IOException, ServletException {
        Condition c = new Condition();
        c.setName("hdr");
        c.setValue("aaa([a-z]+)ccc");
        Rule rule = new Rule();
        rule.setFrom("([a-z])rom");
        rule.setTo("$1 to %{remote-host} %1 here \\%2");
        rule.addCondition(c);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        request.setRemoteHost("server!");
        request.addHeader("hdr", "aaabbbccc");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertTrue((boolean)rule.isToContainsBackReference());
        RuleTest.assertTrue((boolean)rule.isToContainsVariable());
        RuleTest.assertEquals((String)"Should have replaced back reference", (String)"f to server! bbb here %2", (String)rewrittenUrl.getTarget());
    }

    public void testRuleBackRefVar() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("start ctx: %{context-path}, hdr: %{header:bananna} %{header:}%{::}%{%{}, escaped var: \\%{ignoreme!}, bad var: %{} %{wibble} end");
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        request.setContextPath("ctxpath");
        request.setRemoteHost("server!");
        request.addHeader("bananna", "bender");
        request.setServerPort(90210);
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertFalse((boolean)rule.isToContainsBackReference());
        RuleTest.assertTrue((boolean)rule.isToContainsVariable());
        RuleTest.assertEquals((String)"forward should be default type", (String)"forward", (String)rule.getToType());
        RuleTest.assertEquals((String)"start ctx: ctxpath, hdr: bender , escaped var: %{ignoreme!}, bad var:   end", (String)rewrittenUrl.getTarget());
        RuleTest.assertTrue((String)"Should be a forward", (boolean)rewrittenUrl.isForward());
    }

    public void testRuleBadCondition() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("to");
        Condition condition = new Condition();
        condition.setType("port");
        condition.setValue("aaa");
        rule.addCondition(condition);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((Object)rewrittenUrl);
    }

    public void testRuleConditionsOr() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("to");
        Condition condition = new Condition();
        condition.setType("port");
        condition.setValue("90");
        condition.setNext("or");
        rule.addCondition(condition);
        Condition condition2 = new Condition();
        condition2.setType("port");
        condition2.setValue("99");
        rule.addCondition(condition2);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        request.setServerPort(88);
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((String)"should not be rewritten", (Object)rewrittenUrl);
        request.setServerPort(90);
        RewrittenUrl rewrittenUrl2 = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"should not be rewritten", (String)"to", (String)rewrittenUrl2.getTarget());
        request.setServerPort(99);
        RewrittenUrl rewrittenUrl3 = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"should not be rewritten", (String)"to", (String)rewrittenUrl3.getTarget());
    }

    public void testRuleConditionsAnd() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("to");
        Condition condition = new Condition();
        condition.setType("port");
        condition.setValue("90");
        rule.addCondition(condition);
        Condition condition2 = new Condition();
        condition2.setType("character-encoding");
        condition2.setValue("utf8");
        rule.addCondition(condition2);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        request.setServerPort(88);
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((String)"should not be rewritten", (Object)rewrittenUrl);
        request.setServerPort(90);
        RewrittenUrl rewrittenUrl2 = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((String)"should not be rewritten", (Object)rewrittenUrl2);
        request.setCharacterEncoding("utf8");
        RewrittenUrl rewrittenUrl3 = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"should be rewritten", (String)"to", (String)rewrittenUrl3.getTarget());
    }

    public void testRuleBadRegexp() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("fro[m");
        rule.setTo("to");
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((Object)rewrittenUrl);
    }

    public void testRuleCaseInsensitive() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("fRom");
        rule.setTo("to");
        Condition condition = new Condition();
        condition.setName("agent");
        condition.setValue("aAa");
        rule.addCondition(condition);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        request.addHeader("agent", "aaa");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)rewrittenUrl.getTarget(), (String)"to");
    }

    public void testRuleRewriteReq() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setEncodeToUrl(true);
        rule.setTo("to");
        rule.setToType("permanent-redirect");
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertTrue((boolean)rewrittenUrl.isEncode());
        RuleTest.assertTrue((boolean)rewrittenUrl.isPermanentRedirect());
    }

    public void testRuleNoInit() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("to");
        MockRequest request = new MockRequest("from");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((Object)rewrittenUrl);
    }

    public void testRuleNotEnabled() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("to");
        rule.setEnabled(false);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((Object)rewrittenUrl);
    }

    public void testRule02() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("/countries/([a-z]+)/");
        rule.setTo("/countries/index.jsp?c=$1");
        rule.setToType("redirect");
        rule.initialise(null);
        MockRequest request = new MockRequest("/countries/australia/");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        MockRequest request2 = new MockRequest("/blah/");
        RewrittenUrl rewrittenUrl2 = rule.execute(request2.getRequestURI(), request2, this.response);
        RuleTest.assertEquals((String)"/countries/index.jsp?c=australia", (String)rewrittenUrl.getTarget());
        RuleTest.assertEquals((String)"redirect", (String)rule.getToType());
        RuleTest.assertTrue((boolean)rewrittenUrl.isRedirect());
        RuleTest.assertNull((String)"Rule should not match", (Object)rewrittenUrl2);
    }

    public void testRuleCondition() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("to");
        Condition condition = new Condition();
        condition.setType("port");
        condition.setValue("5050");
        rule.addCondition(condition);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        request.setServerPort(5050);
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"to", (String)rewrittenUrl.getTarget());
    }

    public void testRuleErikBug() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("^(.*)$");
        rule.setTo("http://short.com/context$1");
        Condition condition = new Condition();
        condition.setName("host");
        condition.setOperator("notequal");
        condition.setValue("short\\.com");
        rule.addCondition(condition);
        rule.initialise(null);
        MockRequest request = new MockRequest("/blahurl");
        request.addHeader("host", "short.com");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"no rewriting should be necessary", null, (Object)rewrittenUrl);
        request.addHeader("host", "www.notexample.com");
        RewrittenUrl rewrittenUrl2 = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"http://short.com/context/blahurl", (String)rewrittenUrl2.getTarget());
    }

    public void testRule08() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("/$");
        rule.setTo("/opencms/opencms/index.html");
        rule.initialise(null);
        MockRequest request = new MockRequest("/");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"/opencms/opencms/index.html", (String)rewrittenUrl.getTarget());
        request = new MockRequest("/xyz");
        rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((Object)rewrittenUrl);
    }

    public void testRuleTrailingSlashRedirect() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("/~quux/foo$");
        rule.setTo("/~quux/foo/");
        rule.initialise(null);
        MockRequest request = new MockRequest("/~quux/foo");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"/~quux/foo/", (String)rewrittenUrl.getTarget());
    }

    public void testRule10() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("/products/([0-9]+)");
        rule.setTo("/index.jsp?product_id=$1");
        rule.initialise(null);
        MockRequest request = new MockRequest("/products/105874");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"/index.jsp?product_id=105874", (String)rewrittenUrl.getTarget());
    }

    public void testRule11() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("^/([a-z]+)/$");
        rule.setTo("/$1/index.jsp");
        rule.initialise(null);
        MockRequest request = new MockRequest("/dir/");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"/dir/index.jsp", (String)rewrittenUrl.getTarget());
    }

    public void testFailedRule1() throws IOException, ServletException {
        String uri = "/article/blah/";
        Rule rule = new Rule();
        rule.setFrom("/article/([0-9]+)/([0-9]+)/([0-9]+)/([a-zA-Z0-9]+)/");
        rule.setTo("/article/index.jsp?year=$1&month=$2&day=$3&code=$4");
        rule.initialise(null);
        MockRequest request = new MockRequest(uri);
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((Object)rewrittenUrl);
    }

    public void testRuleConditionsUserInRole() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("from");
        rule.setTo("to");
        Condition condition = new Condition();
        condition.setType("user-in-role");
        condition.setValue("admin");
        condition.setOperator("notequal");
        rule.addCondition(condition);
        Condition condition2 = new Condition();
        condition2.setType("user-in-role");
        condition2.setValue("boss");
        condition2.setOperator("notequal");
        rule.addCondition(condition2);
        rule.initialise(null);
        MockRequest request = new MockRequest("from");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"should be rewritten", (String)"to", (String)rewrittenUrl.getTarget());
        request.addRole("boss");
        RewrittenUrl rewrittenUrl2 = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertNull((String)"should not be rewritten", (Object)rewrittenUrl2);
    }

    public void testBlindRedirect() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("^/logo\\.gif$");
        rule.setToType("permanent-redirect");
        rule.setTo("http://de010009\\.de\\.ina\\.com:8080/urlrewrite/artifact_type\\.gif");
        rule.initialise(null);
        MockRequest request = new MockRequest("/logo.gif");
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)"http://de010009.de.ina.com:8080/urlrewrite/artifact_type.gif", (String)rewrittenUrl.getTarget());
        RuleTest.assertTrue((boolean)rewrittenUrl.isPermanentRedirect());
        RuleTest.assertFalse((boolean)rewrittenUrl.isEncode());
    }

    public void testRuleHighChar() throws IOException, ServletException {
        Rule rule = new Rule();
        rule.setFrom("/aa\\?a=(.*)");
        rule.setEncodeToUrl(true);
        rule.setTo("$1");
        rule.setToType("permanent-redirect");
        rule.initialise(null);
        String highStr = new String("\u00f6\u236a\u2e88".getBytes(), "UTF8");
        MockRequest request = new MockRequest("/aa?a=" + highStr);
        RewrittenUrl rewrittenUrl = rule.execute(request.getRequestURI(), request, this.response);
        RuleTest.assertEquals((String)highStr, (String)rewrittenUrl.getTarget());
    }

    public void testRuleCookieEmpty() throws IOException, ServletException {
        Condition c = new Condition();
        c.setType("cookie");
        c.setName("abcdef");
        Rule rule = new Rule();
        rule.setFrom("/a\\.jsp");
        rule.setTo("/b.jsp");
        rule.addCondition(c);
        rule.initialise(null);
        RewrittenUrl rewrittenUrl = rule.execute("/a.jsp", this.request, this.response);
        RuleTest.assertTrue((this.request.getCookies() == null ? 1 : 0) != 0);
        RuleTest.assertTrue((rewrittenUrl == null ? 1 : 0) != 0);
        c = new Condition();
        c.setType("cookie");
        c.setName("abcdef");
        c.setOperator("notequal");
        rule = new Rule();
        rule.setFrom("/a\\.jsp");
        rule.setTo("/b.jsp");
        rule.addCondition(c);
        rule.initialise(null);
        rewrittenUrl = rule.execute("/a.jsp", this.request, this.response);
        RuleTest.assertTrue((this.request.getCookies() == null ? 1 : 0) != 0);
        RuleTest.assertEquals((String)"/b.jsp", (String)rewrittenUrl.getTarget());
    }
}

