/**************************GNU_HACKS.H*************************/
/*
 * This header file contains hacks that will simulate the effects of certain
 * parts of VAX-C that are not implemented in GNU-C.  This header file is
 * written in such a way that there are macros for both GNU-C and VAX-C.
 * Thus if you use the macros defined here in your program, you should be
 * able to compile your program with either compiler with no source
 * modifications.
 *
 * Note: The globalvalue implementation is a little bit different than it is
 * on VAX-C.  You can declare a data variable to be a globalvalue, but the
 * data type that the compiler will see will be a pointer to that data type,
 * not that data type.  If you find the warning messages intollerable, you can
 * define a macro to type cast the globalvalue variable back to the expected
 * type.  Since it is impossible to define a macro while expanding another
 * macro, this was not done here.
 *
 * Also, globaldef/ref/value of enum is not implemented.  To simulate this in
 * GNU-C, you can globaldef an integer variable, and then define all of the
 * values that this variable can take to be globalvalue.
 *
 * The arguments to these macros are "fragile" (in the LaTeX sense). This means
 * that you cannot use type casts or expressions in the name field.
 *
 * The globals here are slightly different than the ones in the gcc 2.0 
 * manual in that there is an explicit data type argument.  This is 
 * required in order to make it possible to successfully use a different 
 * variant of the macros with VAX-C.
 */
#ifndef __GNU_HACKS_H_
#define __GNU_HACKS_H_

#ifdef __GNUC__
/* Store the data in a psect by the same name as the  variable name */

#define GLOBALREF(TYPE,NAME) \
	TYPE NAME __asm("_$$PsectAttributes_GLOBALSYMBOL$$" #NAME  )
#define GLOBALDEF(TYPE,NAME,VALUE) \
	TYPE NAME __asm("_$$PsectAttributes_GLOBALSYMBOL$$" #NAME ) = VALUE

#define GLOBALVALUEREF(TYPE,NAME) \
	const TYPE NAME [1] __asm("_$$PsectAttributes_GLOBALVALUE$$" #NAME  )

#define GLOBALVALUEDEF(TYPE,NAME,VALUE) \
	const TYPE NAME [1] __asm("_$$PsectAttributes_GLOBALVALUE$$" #NAME  ) = {VALUE}

/* Store the data in a psect by a different name than the variable name */

#define GBLDEF_ALIAS(TYPE,NAME,ALIAS,VALUE) \
	TYPE NAME __asm("_$$PsectAttributes_GLOBALSYMBOL$$" #ALIAS  ) = VALUE
#define GBLREF_ALIAS(TYPE,NAME,ALIAS) \
	TYPE NAME __asm("_$$PsectAttributes_GLOBALSYMBOL$$" #ALIAS  )

#define NOSHARE(NAME)  NAME __asm("_$$PsectAttributes_NOSHR$$" #NAME  )

#else

/* These are the equivalent definitions that will work in VAX-C */
#define GLOBALREF(TYPE,NAME) globalref TYPE NAME
#define GLOBALDEF(TYPE,NAME,VALUE) globaldef TYPE NAME = VALUE

#define GLOBALVALUEDEF(TYPE,NAME,VALUE) globalvalue TYPE NAME = VALUE

#define GLOBALVALUEREF(TYPE,NAME) globalvalue TYPE NAME

#define NOSHARE(NAME)  noshare NAME

#define GBLDEF_ALIAS(TYPE,NAME,ALIAS,VALUE) globaldef{#ALIAS} TYPE NAME = VALUE

#define GBLREF_ALIAS(TYPE,NAME,ALIAS) globalref{#ALIAS} TYPE NAME

#endif

#endif /* __GNU_HACKS_H_ */
