/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ClassRep;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class JavaCastCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 1, argv, "class javaObj");
        }
        Class cast_to = ClassRep.get(interp, argv[1]);
        Object obj = ReflectObject.get(interp, argv[2]);
        if (obj == null) {
            interp.setResult(ReflectObject.newInstance(interp, cast_to, obj));
            return;
        }
        Class<?> cast_from = obj.getClass();
        if (cast_to.isAssignableFrom(cast_from)) {
            interp.setResult(ReflectObject.newInstance(interp, cast_to, obj));
            return;
        }
        throw new TclException(interp, "could not cast from " + JavaInfoCmd.getNameFromClass(cast_from) + " to " + JavaInfoCmd.getNameFromClass(cast_to));
    }

    JavaCastCmd() {
    }
}

