/* module: 4dd_cmdtab.c command and help table definition */

static char SccsId[] = "@(#)4dd_cmdtab.c	1.1";

#include <stdio.h>
#include "4dd_echo.h"

/* command entry points */

extern int save();
extern int fetch();
extern int echoclear();
extern int edit();
extern int name();
extern int echo_scale();
extern int status_long();
extern int status_short();
extern int exit_();
extern int help();
extern int nullcmd();
extern int display();

struct CMDTAB cmdtab[] = {
	"save",		2,	save,		"save image on disc",
	"fetch",	2,	fetch,		"fetch image from disc",
	"clear",	2,	echoclear,	"clear the image",
	"display",	2,	edit,		"image display",
	"name",		2,	name,		"show or change name",
	"scale",	2,	echo_scale,	"scale the image",
	"status",	2,	status_long,"display statistics",
	"exit",		2,	exit_,		"shutdown the system",
	"quit",		1,	exit_,		"shutdown the system",
	"help",		1,	help,		"display help screen",
	"",			0,	0,			""
};
