
/*******************************************************************************
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: fstime.c   SID: 2.1 8/6/89 22:24:25
 *          
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Ben Smith or Rick Grehan at BYTE Magazine
 *	bensmith@bixpb.UUCP    rick_g@bixpb.UUCP
 *
 *******************************************************************************
 *  Modification Log:
 * $Header: fstime.c,v 3.4 87/06/22 14:23:05 kjmcdonell Beta $
 *
 ******************************************************************************/
char SCCSid[] = "@(#) @(#)fstime.c:2.1 -- 8/6/89 22:24:25";

#include <stdio.h>
#include <sys/types.h>
#ifdef SysV
#include <sys/times.h>
#include <sys/param.h>
#ifdef interdata
#define HZ tbuffer.tms_cfreq
#endif
#ifndef HZ
	On your system, what is the value of HZ for high resolution elapsed
	time as returned by times() or its equivalent?
#endif
#endif
#ifdef BSD4v1
#include <sys/timeb.h>
#endif
#ifdef BSD4v2
#include <sys/time.h>
#endif
#define NKBYTE 20
char buf[BUFSIZ];

main(argc, argv)
char **argv;
{
    int			n = NKBYTE;
    int			nblock;
    int			f;
    int			g;
    int			i;
    int			xfer, t;
    long		then;
#ifdef BSD4v1
    struct timeb	tbuf;
    int			msec;
#endif
#ifdef BSD4v2
    struct timeval	tval;
    struct timezone	tzone;
    long		usec;
#endif
#ifdef SysV
    struct tms		tbuffer;
#endif

    if (argc > 1)
	n = atoi(argv[1]);
#if debug
    printf("File size: %d Kbytes\n", n);
#endif
    nblock = (n * 1024) / BUFSIZ;

    if (argc == 3 && chdir(argv[2]) != -1) {
#if debug
	printf("Create files in directory: %s\n", argv[2]);
#endif
    }
    close(creat("dummy0", 0600));
    close(creat("dummy1", 0600));
    f = open("dummy0", 2);
    g = open("dummy1", 2);
    unlink("dummy0");
    unlink("dummy1");
    for (i = 0; i < sizeof(buf); i++)
	buf[i] = i & 0177;

#ifdef SysV
    then = times(&tbuffer);
#else
#ifdef BSD4v1
    ftime(&tbuf);
    then = tbuf.time;
    msec = tbuf.millitm;
#else
#ifdef BSD4v2
    gettimeofday(&tval, &tzone);
    then = tval.tv_sec;
    usec = tval.tv_usec;
#else
    What sort of Unix system is this?
#endif
#endif
#endif
    for (i = 0; i < nblock; i++) {
	if (write(f, buf, sizeof(buf)) <= 0)
	    perror("fstime: write");
    }
#ifdef SysV
    t = 1000*(times(&tbuffer) - then)/HZ;
#endif
#ifdef BSD4v1
    ftime(&tbuf);
    t = (tbuf.time - then)*1000 + tbuf.millitm - msec;
#endif
#ifdef BSD4v2
    gettimeofday(&tval, &tzone);
    t = (tval.tv_sec - then)*1000 + (tval.tv_usec - usec)/1000;
#endif
#if debug
    printf("Effective write rate: ");
#endif
    if (t > 0) {
	xfer = nblock * sizeof(buf) * 1000 / t;
#if debug
	printf("%d bytes/sec\n", xfer);
#endif
    }
#if debug
    else
	printf(" -- too quick to time!\n");
#endif
#if awk
    fprintf(stderr, "%.2f", t > 0 ? (float)xfer/1024 : 0);
#endif

    sync();
    sleep(5);
    sync();
    lseek(f, 0L, 0);
#ifdef SysV
    then = times(&tbuffer);
#endif
#ifdef BSD4v1
    times(&tbuf);
    then = tbuf.time;
    msec = tbuf.millitm;
#endif
#ifdef BSD4v2
    gettimeofday(&tval, &tzone);
    then = tval.tv_sec;
    usec = tval.tv_usec;
#endif
    for (i = 0; i < nblock; i++) {
	if (read(f, buf, sizeof(buf)) <= 0)
	    perror("fstime: read");
    }
#ifdef SysV
    t = 1000*(times(&tbuffer) - then)/HZ;
#endif
#ifdef BSD4v1
    ftime(&tbuf);
    t = (tbuf.time - then)*1000 + tbuf.millitm - msec;
#endif
#ifdef BSD4v2
    gettimeofday(&tval, &tzone);
    t = (tval.tv_sec - then)*1000 + (tval.tv_usec - usec)/1000;
#endif
#if debug
    printf("Effective read rate: ");
#endif
    if (t > 0) {
	xfer = nblock * sizeof(buf) * 1000 / t;
#if debug
	printf("%d bytes/sec\n", xfer);
#endif
    }
#if debug
    else
	printf(" -- too quick to time!\n");
#endif
#if awk
    fprintf(stderr, " %.2f", t > 0 ? (float)xfer/1024 : 0);
#endif

    sync();
    sleep(5);
    sync();
    lseek(f, 0L, 0);
#ifdef SysV
    then = times(&tbuffer);
#endif
#ifdef BSD4v1
    times(&tbuf);
    then = tbuf.time;
    msec = tbuf.millitm;
#endif
#ifdef BSD4v2
    gettimeofday(&tval, &tzone);
    then = tval.tv_sec;
    usec = tval.tv_usec;
#endif
    for (i = 0; i < nblock; i++) {
	if (read(f, buf, sizeof(buf)) <= 0)
	    perror("fstime: read in copy");
	if (write(g, buf, sizeof(buf)) <= 0)
	    perror("fstime: write in copy");
    }
#ifdef SysV
    t = 1000*(times(&tbuffer) - then)/HZ;
#endif
#ifdef BSD4v1
    ftime(&tbuf);
    t = (tbuf.time - then)*1000 + tbuf.millitm - msec;
#endif
#ifdef BSD4v2
    gettimeofday(&tval, &tzone);
    t = (tval.tv_sec - then)*1000 + (tval.tv_usec - usec)/1000;
#endif
#if debug
    printf("Effective copy rate: ");
#endif
    if (t > 0) {
	xfer = nblock * sizeof(buf) * 1000 / t;
#if debug
	printf("%d bytes/sec\n", xfer);
#endif
    }
#if debug
    else
	printf(" -- too quick to time!\n");
#endif
#if awk
    fprintf(stderr, " %.2f\n", t > 0 ? (float)xfer/1024 : 0);
#endif
    exit(0);
}
