untrusted comment: verify with openbsd-64-base.pub
RWQq6XmS4eDAcZZphSgc4yldvb4lcFk5FxU6/W7ghDmh9DtV4FEBX6hCQYp+bLu8AHrBJmbrLL81tUrK/VGM5keGamYb1uXFxwc=

OpenBSD 6.4 errata 025, October 5, 2019

Specially crafted queries may crash unbound.

Apply by doing:
    signify -Vep /etc/signify/openbsd-64-base.pub -x 025_unbound.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install unbound:

    cd /usr/src/usr.sbin/unbound
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install

Index: usr.sbin/unbound/util/data/msgparse.c
===================================================================
RCS file: /cvs/src/usr.sbin/unbound/util/data/msgparse.c,v
retrieving revision 1.5
diff -u -p -r1.5 msgparse.c
--- usr.sbin/unbound/util/data/msgparse.c	17 Sep 2018 09:46:12 -0000	1.5
+++ usr.sbin/unbound/util/data/msgparse.c	3 Oct 2019 12:01:25 -0000
@@ -1061,18 +1061,18 @@ parse_edns_from_pkt(sldns_buffer* pkt, s
 	size_t rdata_len;
 	uint8_t* rdata_ptr;
 	log_assert(LDNS_QDCOUNT(sldns_buffer_begin(pkt)) == 1);
+	memset(edns, 0, sizeof(*edns));
 	if(LDNS_ANCOUNT(sldns_buffer_begin(pkt)) != 0 ||
 		LDNS_NSCOUNT(sldns_buffer_begin(pkt)) != 0) {
 		if(!skip_pkt_rrs(pkt, ((int)LDNS_ANCOUNT(sldns_buffer_begin(pkt)))+
 			((int)LDNS_NSCOUNT(sldns_buffer_begin(pkt)))))
-			return 0;
+			return LDNS_RCODE_FORMERR;
 	}
 	/* check edns section is present */
 	if(LDNS_ARCOUNT(sldns_buffer_begin(pkt)) > 1) {
 		return LDNS_RCODE_FORMERR;
 	}
 	if(LDNS_ARCOUNT(sldns_buffer_begin(pkt)) == 0) {
-		memset(edns, 0, sizeof(*edns));
 		edns->udp_size = 512;
 		return 0;
 	}
