/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "../mainline/src/test-inputbuf.cm" instead.
 */

#include <check.h>

#line 1 "../mainline/src/test-inputbuf.cm"
/* -*- c -*- */
/* test-inputbuf.cm: tests for inputbuf.c. */

/*
    Copyright (C) 2008 Micah Cowan

    This file is part of GNU teseq.

    GNU teseq is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    GNU teseq is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "teseq.h"

#include <stdio.h>
#include <stdlib.h>

#include "inputbuf.h"

struct inputbuf *the_buffer;

void
initfile (void)
{
  FILE *f = fopen ("src/test-inputbuf.inf", "r");
  fail_if (f == NULL);
  the_buffer = inputbuf_new (f, 10);
}

START_TEST(basic)
{
#line 41
        /* Reading from the file. */
        fail_unless (inputbuf_get (the_buffer) == 'a');
        fail_unless (inputbuf_get (the_buffer) == 'b');
        fail_unless (inputbuf_get_count (the_buffer) == 2);
        fail_unless (inputbuf_saving (the_buffer) == 0);
        /* Reading from the file, and filling the buffer. */
        fail_unless (inputbuf_get (the_buffer) == 'c');
        fail_unless (inputbuf_get (the_buffer) == 'd');
        fail_unless (inputbuf_get (the_buffer) == 'e');
        /* Count doesn't increment during a save; still 2. */
        fail_unless (inputbuf_get_count (the_buffer) == 2);
        fail_unless (inputbuf_rewind (the_buffer) == 0);
        /* Consuming the save buffer. */
        fail_unless (inputbuf_get (the_buffer) == 'c');
        fail_unless (inputbuf_get (the_buffer) == 'd');
        fail_unless (inputbuf_get_count (the_buffer) == 4);
        fail_unless (inputbuf_saving (the_buffer) == 0);
        /* Reading from the buffer, but not consuming. */
        fail_unless (inputbuf_get (the_buffer) == 'e');
        fail_unless (inputbuf_get_count (the_buffer) == 4);
        fail_unless (inputbuf_forget (the_buffer) == 0);
        /* Count is incremented to the total read characters upon
           inputbuf_forget. */
        fail_unless (inputbuf_get_count (the_buffer) == 5);
        inputbuf_reset_count (the_buffer);
        fail_unless (inputbuf_get_count (the_buffer) == 0);
        /* Reading from the file. */
        fail_unless (inputbuf_get (the_buffer) == 'f');
        fail_unless (inputbuf_get (the_buffer) == 'g');
        fail_unless (inputbuf_get (the_buffer) == 'h');
        /* Reading at EOF. (A saved EOF should give EOF on re-read.) */
        fail_unless (inputbuf_saving (the_buffer) == 0);
        fail_unless (inputbuf_get (the_buffer) == EOF);
        fail_unless (inputbuf_rewind (the_buffer) == 0);
        fail_unless (inputbuf_get (the_buffer) == EOF);

}
END_TEST

START_TEST(avail)
{
#line 78
        fail_unless (inputbuf_avail (the_buffer) == 0);
        fail_unless (inputbuf_get (the_buffer) == 'a');
        fail_unless (inputbuf_get (the_buffer) == 'b');
        fail_unless (inputbuf_get (the_buffer) == 'c');
        /* Haven't buffered anything, so nothing avail: */
        fail_unless (inputbuf_avail (the_buffer) == 0);
        fail_unless (inputbuf_saving (the_buffer) == 0);
        fail_unless (inputbuf_get (the_buffer) == 'd');
        fail_unless (inputbuf_get (the_buffer) == 'e');
        fail_unless (inputbuf_rewind (the_buffer) == 0);
        fail_unless (inputbuf_avail (the_buffer) != 0);
        fail_unless (inputbuf_get (the_buffer) == 'd');
        fail_unless (inputbuf_get (the_buffer) == 'e');
        fail_unless (inputbuf_avail (the_buffer) == 0);

}
END_TEST

START_TEST(limits)
{
#line 96
        FILE *f = fopen ("src/test-inputbuf.inf", "r");
        fail_if (f == NULL);
        the_buffer = inputbuf_new (f, 3);
        fail_unless (inputbuf_saving (the_buffer) == 0);
        fail_unless (inputbuf_get (the_buffer) == 'a');
        fail_unless (inputbuf_get (the_buffer) == 'b');
        fail_unless (inputbuf_get (the_buffer) == 'c');
        fail_unless (inputbuf_get (the_buffer) == -1);

}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("Core");
    TCase *tc1_1 = tcase_create("Core");
    TCase *tc1_2 = tcase_create("bounds");
    SRunner *sr = srunner_create(s1);
    int nf;

    /* User-specified pre-run code */
#line 106
        tcase_add_checked_fixture (tc1_1, initfile, NULL);

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, basic);
    tcase_add_test(tc1_1, avail);
    suite_add_tcase(s1, tc1_2);
    tcase_add_test(tc1_2, limits);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
