/*-
 * gethostid.c --
 *
 *	This routine maps the 4.3BSD gethostid system call onto the
 *	System V utime call on systems that have a struct utsname that include
 *	a system identification number (like HP-UX).
 *
 */
#ifndef lint
static char *rcsid = "$Id: gethostid.c,v 1.2 1992/07/31 00:12:31 stolcke Exp $ ICSI (Berkeley)";
#endif lint

#include <sys/utsname.h>

int
gethostid()
{
    struct utsname name;

    if (uname(&name) < 0) {
	perror("uname");
	return -1;
    }

    return atoi(name.__idnumber);
}
