# macintosh.tcl --
# Macintosh platform specific settings
# Note that there is also some platform code in main.tcl to bootstap things

# Pick a small display size so we can get to the resize handle
option add *Text.height 		25 	startup
option add *Text.width 			80 	startup

option add *Toolbar*Button.side {left -padx 2} startup

# Menu accelerators
option add *Menubar.file.m.a_save <Command-s> startup
option add *Menubar.file.m.b_save TSelect startup
option add *Menubar.file.m.a_refresh <Command-l> startup
option add *Menubar.file.m.b_refresh TSelect startup
option add *Menubar.file.m.a_close <Command-w> startup
option add *Menubar.file.m.b_close TSelect startup
option add *Menubar.file.m.a_quit <Command-q> startup
option add *Menubar.file.m.b_quit TSelect startup
option add *Menubar.edit.m.a_undo <Command-z> startup
option add *Menubar.edit.m.b_copy TSelect startup
option add *Menubar.edit.m.a_cut <Command-x> startup
option add *Menubar.edit.m.b_cut HText startup
option add *Menubar.edit.m.a_paste <Command-v> startup
option add *Menubar.edit.m.b_paste HText startup
option add *Menubar.edit.m.a_find <Command-f> startup
option add *Menubar.edit.m.b_find TSelect startup
option add *Menubar.go.m.a_back <Command-b> startup
option add *Menubar.go.m.b_back TSelect startup
option add *Menubar.help.m.a_help <Key-Help> startup
option add *Menubar.help.m.b_help TSelect startup

# Create a font named "fixed"
if {$tk_version >= 8.0} {
    font create fixed -family Courier -size 10
}

# The name of the per-user preferences file
proc Platform_File {key} {
    switch $key {
	prefs {
	    return ":WebTk Preferences"
	}
	macros {
	    return ":WebTk Macros"
	}
	tcl {
	    return ":WebTk User Tcl Code"
	}
	def {
	    return ":WebTk User Preferences"
	}
	log {
	    return ":WebTk Log File"
	}
	tmp {
	    return ":Temp File"
	}
    }
}

# Wait for a dialog before doing a grab
proc Platform_WaitVisibility {win} {
    catch {tkwait visibility $win}
}

proc Platform_TempFile {url} {
    global WebTk
    regsub {(\?|#).*} $url {} url
    file mkdir [file join $WebTk(home) cache]
    return [file join $WebTk(home) cache [lindex [split $url /] end]]
}

proc Platform_Install {{src webtk:} {dest "Hard Disk:Tcl/Tk 4.1:webtk"}} {
    set save [pwd]
    cd $src
    foreach f [lsort [glob *.TCL *.tcl tclIndex]] { 
	puts $f ; update idletasks
	File_Copy $f $dest
    }
    foreach dir [list [file join $dest html] [file join $dest images]] {
	catch {mkdir $dir}
	cd $dir
	foreach f [lsort [glob *]] {
	    puts $f ; update idletasks
	    File_Copy $f $dir
	}
    }
    cd $save
}

