/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import tcl.lang.ClassRep;
import tcl.lang.FieldSig;
import tcl.lang.FuncSig;
import tcl.lang.Interp;
import tcl.lang.JavaNullCmd;
import tcl.lang.PropertySig;
import tcl.lang.ReflectException;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclClassLoader;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.reflect.PkgInvoker;

class JavaInvoke {
    private static Object[] EMPTY_ARGS = new Object[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    static TclObject newInstance(Interp interp, TclObject signature, TclObject[] argv, int startIdx, int count) throws TclException {
        FuncSig sig = FuncSig.get(interp, null, signature, argv, startIdx, count);
        Object javaObj = JavaInvoke.call(interp, sig.pkgInvoker, signature, sig.func, null, argv, startIdx, count);
        return ReflectObject.newInstance(interp, sig.targetCls, javaObj);
    }

    static TclObject callMethod(Interp interp, TclObject reflectObj, TclObject signature, TclObject[] argv, int startIdx, int count, boolean convert) throws TclException {
        Object javaObj = ReflectObject.get(interp, reflectObj);
        Class javaCl = ReflectObject.getClass(interp, reflectObj);
        FuncSig sig = FuncSig.get(interp, javaCl, signature, argv, startIdx, count);
        Method method = (Method)sig.func;
        Object result = JavaInvoke.call(interp, sig.pkgInvoker, signature, method, javaObj, argv, startIdx, count);
        if (method.getReturnType() == Void.TYPE) {
            return TclString.newInstance("");
        }
        return JavaInvoke.wrap(interp, method.getReturnType(), result, convert);
    }

    static TclObject callStaticMethod(Interp interp, TclObject classObj, TclObject signature, TclObject[] argv, int startIdx, int count, boolean convert) throws TclException {
        Class cls = ClassRep.get(interp, classObj);
        FuncSig sig = FuncSig.get(interp, cls, signature, argv, startIdx, count);
        Method method = (Method)sig.func;
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new TclException(interp, "\"" + signature + "\" is not a static method of class \"" + classObj + "\"");
        }
        Object result = JavaInvoke.call(interp, sig.pkgInvoker, signature, method, null, argv, startIdx, count);
        if (method.getReturnType() == Void.TYPE) {
            return TclString.newInstance("");
        }
        return JavaInvoke.wrap(interp, method.getReturnType(), result, convert);
    }

    static Object call(Interp interp, PkgInvoker invoker, TclObject signature, Object func, Object obj, TclObject[] argv, int startIdx, int count) throws TclException {
        Object[] args;
        Class<?>[] paramTypes;
        Constructor cons = null;
        Method method = null;
        boolean isConstructor = func instanceof Constructor;
        if (isConstructor) {
            cons = (Constructor)func;
            paramTypes = cons.getParameterTypes();
        } else {
            method = (Method)func;
            paramTypes = method.getParameterTypes();
        }
        if (count != paramTypes.length) {
            throw new TclException(interp, "wrong # args for calling " + (isConstructor ? "constructor" : "method") + " \"" + signature + "\"");
        }
        if (count == 0) {
            args = EMPTY_ARGS;
        } else {
            args = new Object[count];
            int i = 0;
            while (i < count) {
                args[i] = JavaInvoke.convertTclObject(interp, paramTypes[i], argv[i + startIdx]);
                ++i;
            }
        }
        try {
            if (isConstructor) {
                return invoker.invokeConstructor(cons, args);
            }
            return invoker.invokeMethod(method, obj, args);
        }
        catch (Exception e) {
            throw new ReflectException(interp, (Throwable)e);
        }
    }

    static final TclObject getField(Interp interp, TclObject classOrObj, TclObject signature, boolean convert) throws TclException {
        return JavaInvoke.getsetField(interp, classOrObj, signature, null, convert, true);
    }

    static final void setField(Interp interp, TclObject classOrObj, TclObject signature, TclObject value) throws TclException {
        JavaInvoke.getsetField(interp, classOrObj, signature, value, false, false);
    }

    static TclObject getsetField(Interp interp, TclObject classOrObj, TclObject signature, TclObject value, boolean convert, boolean isget) throws TclException {
        Class cls = null;
        Object obj = null;
        boolean isStatic = false;
        try {
            obj = ReflectObject.get(interp, classOrObj);
        }
        catch (TclException tclException) {
            try {
                cls = ClassRep.get(interp, classOrObj);
            }
            catch (TclException tclException2) {
                throw new TclException(interp, "unknown class or object \"" + classOrObj + "\"");
            }
            isStatic = true;
        }
        if (!isStatic) {
            if (obj == null) {
                throw new TclException(interp, "can't access fields in a null object reference");
            }
            cls = ReflectObject.getClass(interp, classOrObj);
        }
        FieldSig sig = FieldSig.get(interp, signature, cls);
        Field field = sig.field;
        if (isStatic && !Modifier.isStatic(field.getModifiers())) {
            throw new TclException(interp, "can't access an instance field without an object");
        }
        try {
            if (isget) {
                return JavaInvoke.wrap(interp, field.getType(), sig.pkgInvoker.getField(field, obj), convert);
            }
            Object javaValue = JavaInvoke.convertTclObject(interp, field.getType(), value);
            sig.pkgInvoker.setField(field, obj, javaValue);
            return null;
        }
        catch (TclException e1) {
            throw e1;
        }
        catch (IllegalAccessException e2) {
            throw new TclException(interp, "can't access field \"" + signature + "\": " + e2);
        }
        catch (Exception e) {
            throw new ReflectException(interp, (Throwable)e);
        }
    }

    static TclObject getProperty(Interp interp, TclObject reflectObj, TclObject propName, boolean convert) throws TclException {
        Object javaObj = ReflectObject.get(interp, reflectObj);
        if (javaObj == null) {
            throw new TclException(interp, "can't get property from null object");
        }
        Class javaClass = ReflectObject.getClass(interp, reflectObj);
        PropertySig sig = PropertySig.get(interp, javaClass, propName);
        Method readMethod = sig.desc.getReadMethod();
        if (readMethod == null) {
            throw new TclException(interp, "can't get write-only property \"" + propName + "\"");
        }
        try {
            return JavaInvoke.wrap(interp, readMethod.getReturnType(), sig.pkgInvoker.invokeMethod(readMethod, javaObj, EMPTY_ARGS), convert);
        }
        catch (Exception e) {
            throw new ReflectException(interp, (Throwable)e);
        }
    }

    static void setProperty(Interp interp, TclObject reflectObj, TclObject propName, TclObject value) throws TclException {
        Object javaObj = ReflectObject.get(interp, reflectObj);
        if (javaObj == null) {
            throw new TclException(interp, "can't set property in null object");
        }
        Class javaClass = ReflectObject.getClass(interp, reflectObj);
        PropertySig sig = PropertySig.get(interp, javaClass, propName);
        Method writeMethod = sig.desc.getWriteMethod();
        Class<?> type = sig.desc.getPropertyType();
        if (writeMethod == null) {
            throw new TclException(interp, "can't set read-only property \"" + propName + "\"");
        }
        Object[] args = new Object[]{JavaInvoke.convertTclObject(interp, type, value)};
        try {
            sig.pkgInvoker.invokeMethod(writeMethod, javaObj, args);
        }
        catch (Exception e) {
            throw new ReflectException(interp, (Throwable)e);
        }
    }

    static Class getClassByName(Interp interp, String clsName) throws TclException {
        Class<?> result;
        block29: {
            result = null;
            String prefix = "";
            String suffix = "";
            int dimension = 0;
            while (clsName.endsWith("[]")) {
                int newLen = clsName.length() - 2;
                clsName = clsName.substring(0, newLen);
                prefix = String.valueOf(prefix) + "[";
                ++dimension;
            }
            try {
                if (clsName.indexOf(46) == -1) {
                    if (dimension > 0) {
                        if (clsName.equals("int")) {
                            return Class.forName(String.valueOf(prefix) + "I");
                        }
                        if (clsName.equals("boolean")) {
                            return Class.forName(String.valueOf(prefix) + "Z");
                        }
                        if (clsName.equals("long")) {
                            return Class.forName(String.valueOf(prefix) + "J");
                        }
                        if (clsName.equals("float")) {
                            return Class.forName(String.valueOf(prefix) + "F");
                        }
                        if (clsName.equals("double")) {
                            return Class.forName(String.valueOf(prefix) + "D");
                        }
                        if (clsName.equals("byte")) {
                            return Class.forName(String.valueOf(prefix) + "B");
                        }
                        if (clsName.equals("short")) {
                            return Class.forName(String.valueOf(prefix) + "S");
                        }
                        if (clsName.equals("char")) {
                            return Class.forName(String.valueOf(prefix) + "C");
                        }
                        prefix = String.valueOf(prefix) + "L";
                        suffix = ";";
                    } else {
                        if (clsName.equals("int")) {
                            return Integer.TYPE;
                        }
                        if (clsName.equals("boolean")) {
                            return Boolean.TYPE;
                        }
                        if (clsName.equals("long")) {
                            return Long.TYPE;
                        }
                        if (clsName.equals("float")) {
                            return Float.TYPE;
                        }
                        if (clsName.equals("double")) {
                            return Double.TYPE;
                        }
                        if (clsName.equals("byte")) {
                            return Byte.TYPE;
                        }
                        if (clsName.equals("short")) {
                            return Short.TYPE;
                        }
                        if (clsName.equals("char")) {
                            return Character.TYPE;
                        }
                    }
                    TclClassLoader tclClassLoader = new TclClassLoader(interp, null);
                    try {
                        result = tclClassLoader.loadClass(String.valueOf(prefix) + clsName + suffix);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            result = tclClassLoader.loadClass(String.valueOf(prefix) + "java.lang." + clsName + suffix);
                            break block29;
                        }
                        catch (SecurityException securityException) {
                            result = null;
                        }
                    }
                    break block29;
                }
                TclClassLoader tclClassLoader = new TclClassLoader(interp, null);
                if (dimension > 0) {
                    clsName = String.valueOf(prefix) + "L" + clsName + ";";
                }
                result = tclClassLoader.loadClass(clsName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                result = null;
            }
            catch (SecurityException securityException) {
                throw new TclException(interp, "cannot load new class into java or tcl package");
            }
        }
        if (result == null) {
            throw new TclException(interp, "unknown class \"" + clsName + "\"");
        }
        return result;
    }

    static TclObject convertJavaObject(Interp interp, Class cls, Object javaObj) throws TclException {
        if (javaObj == null) {
            if (cls == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JavaInvoke.class$("java.lang.String")))) {
                return TclString.newInstance("");
            }
            return JavaNullCmd.getNullObj();
        }
        if (javaObj instanceof Integer) {
            return TclInteger.newInstance((Integer)javaObj);
        }
        if (javaObj instanceof Long) {
            return TclInteger.newInstance(((Long)javaObj).intValue());
        }
        if (javaObj instanceof Short) {
            return TclInteger.newInstance(((Short)javaObj).intValue());
        }
        if (javaObj instanceof Byte) {
            return TclInteger.newInstance(((Byte)javaObj).intValue());
        }
        if (javaObj instanceof Double) {
            return TclDouble.newInstance((Double)javaObj);
        }
        if (javaObj instanceof Float) {
            return TclDouble.newInstance(((Float)javaObj).doubleValue());
        }
        if (javaObj instanceof Boolean) {
            return TclBoolean.newInstance((Boolean)javaObj);
        }
        if (javaObj instanceof Character) {
            return TclString.newInstance(((Character)javaObj).toString());
        }
        if (javaObj instanceof String) {
            return TclString.newInstance((String)javaObj);
        }
        return ReflectObject.newInstance(interp, cls, javaObj);
    }

    static final Object convertTclObject(Interp interp, Class type, TclObject tclObj) throws TclException {
        Object javaObj = null;
        boolean isReflectObj = false;
        try {
            javaObj = ReflectObject.get(interp, tclObj);
            isReflectObj = true;
        }
        catch (TclException tclException) {
            interp.resetResult();
        }
        if (!isReflectObj) {
            if (type == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JavaInvoke.class$("java.lang.String")))) {
                return tclObj.toString();
            }
            if (type == (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = JavaInvoke.class$("java.lang.Object")))) {
                return tclObj.toString();
            }
            if (type == Integer.TYPE || type == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = JavaInvoke.class$("java.lang.Integer")))) {
                return new Integer(TclInteger.get(interp, tclObj));
            }
            if (type == Boolean.TYPE || type == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = JavaInvoke.class$("java.lang.Boolean")))) {
                return new Boolean(TclBoolean.get(interp, tclObj));
            }
            if (type == Long.TYPE || type == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = JavaInvoke.class$("java.lang.Long")))) {
                return new Long(TclInteger.get(interp, tclObj));
            }
            if (type == Float.TYPE || type == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = JavaInvoke.class$("java.lang.Float")))) {
                return new Float((float)TclDouble.get(interp, tclObj));
            }
            if (type == Double.TYPE || type == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = JavaInvoke.class$("java.lang.Double")))) {
                return new Double(TclDouble.get(interp, tclObj));
            }
            if (type == Byte.TYPE || type == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = JavaInvoke.class$("java.lang.Byte")))) {
                int i = TclInteger.get(interp, tclObj);
                if (i < -128 || i > 127) {
                    throw new TclException(interp, "integer value too large to represent in a byte");
                }
                return new Byte((byte)i);
            }
            if (type == Short.TYPE || type == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = JavaInvoke.class$("java.lang.Short")))) {
                int i = TclInteger.get(interp, tclObj);
                if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
                    throw new TclException(interp, "integer value too large to represent in a short");
                }
                return new Short((short)i);
            }
            if (type == Character.TYPE || type == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = JavaInvoke.class$("java.lang.Character")))) {
                String str = tclObj.toString();
                if (str.length() == 1) {
                    return new Character(str.charAt(0));
                }
                throw new TclException(interp, "expected character but got \"" + tclObj + "\"");
            }
            throw new TclException(interp, "\"" + tclObj + "\" is not an object handle of class \"" + type.getName() + "\"");
        }
        if (javaObj == null || type.isInstance(javaObj)) {
            return javaObj;
        }
        throw new TclException(interp, "expected object of type " + type.getName() + " but got \"" + tclObj + "\" (" + javaObj.getClass().getName() + ")");
    }

    private static final TclObject wrap(Interp interp, Class cls, Object javaObj, boolean convert) throws TclException {
        if (convert) {
            return JavaInvoke.convertJavaObject(interp, cls, javaObj);
        }
        return ReflectObject.newInstance(interp, cls, javaObj);
    }

    JavaInvoke() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

