/* $Copyright:	$
 * Copyright (c) 1991,1992,1993 by Steve Baker
 * All rights reserved
 *  
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */
#include "shell.h"

extern struct _alias *alias[128];
extern char buf[1025], path[1025];
extern int a,b,c,d;

char ***parse_alias(), **exchange_alias(), **evalwrd(), *sub_parse();
struct _alias *find_alias();

char ***parse_alias(arg)
char ***arg;
{
  int i;

  for(i=0;arg[i];i++)
    arg[i] = (char **)exchange_alias(arg[i]);

  return arg;
}

char **exchange_alias(arg)
char **arg;
{
  int twd,wrd,nt,i,j,max;
  char **tmp, **ptmp, **etmp, *flg, used;
  struct _alias *ALIAS;

  tmp = (char **)calloc(nt = 5,sizeof(char *));

  twd = wrd = 0;
  while(arg[wrd]) {
    ALIAS = find_alias(arg[wrd]);

    if (!ALIAS) {
      while(arg[wrd] && arg[wrd][0] != '|') {
	if (twd == nt) tmp = (char **)realloc(tmp,sizeof(char *) * (nt += 5));
	tmp[twd++] = arg[wrd++];
      }
      if (!arg[wrd]) continue;
      /* we got a | if we got this far */
      if (twd == nt) tmp = (char **)realloc(tmp,sizeof(char *) * (nt += 5));
      tmp[twd++] = arg[wrd++];
      continue;
    }
    /* Our word was an alias, now we have to build up a subwordlist. */
    i = wrd;
    while (arg[wrd] && arg[wrd][0] != '|') wrd++;
    ptmp = (char **)calloc((wrd-i)+1, sizeof(char *));
    for(j=0;j<(wrd-i);j++) ptmp[j] = arg[j+i];
    ptmp[j] = NULL;

    /*
     * got our subwordlist, now we make a flag list.  This should be done
     * in a binary fashion.  Use bits instead of whole bytes.
     */
    flg = (char *)malloc(j+1);
    bzero(flg,j+1);
    flg[j] = -1;
    max = j;
    used = FALSE;

    /* Now we evaluate our alias, one word at a time */
    for(i=0;ALIAS->wrd[i];i++) {
      etmp = (char **)evalwrd(ALIAS->wrd[i],ptmp,flg,max,&used);
      if (!etmp) continue;
      for(j=0;etmp[j];j++) {
	if (twd == nt) tmp = (char **)realloc(tmp,sizeof(char *) * (nt += 5));
	tmp[twd++] = etmp[j];
      }
      free(etmp);
    }

/* check if any args used, if not tack them on to the end of the word list */

    if (!used) {	/* no args used */
      for(i=1;ptmp[i];i++) {
	if (twd == nt) tmp = (char **)realloc(tmp,sizeof(char *) * (nt += 5));
	tmp[twd++] = ptmp[i];
      }
      free(ptmp[0]);
    } else for(i=0;ptmp[i];i++) free(ptmp[i]);
    free(ptmp);
    free(flg);
    if (arg[wrd] && arg[wrd][0] == '|') {
      if (twd == nt) tmp = (char **)realloc(tmp,sizeof(char *) * (nt += 5));
      tmp[twd++] = arg[wrd++];
    }
  }
  if (twd == nt) tmp = (char **)realloc(tmp,sizeof(char *) * (nt += 1));
  tmp[twd] = NULL;
  free(arg);
  return (char **)tmp;
}


char **evalwrd(pat,arg,flg,max,used)
char *pat, **arg, *flg, *used;
int max;
{
  char **tmp, **sav, *s, c;
  int n,m,i,j,nt,bp,pos;

  pos = bp = 0;
  tmp = (char **)malloc(sizeof(char *) * (nt = 2));

  while(*pat) {
    switch(*pat++) {
      case '%':
        if (*pat == '-' || *pat == '+' || *pat == '%' || isdigit(*pat)) {
	  c = *pat;
	  if (isdigit(c)) {
	    s = pat;
	    while(isdigit(*pat)) pat++;
	    m = n = atoi(s);
	    if (n >= max) m = max - 1;
	    if (*pat == '-' && isdigit(*(pat+1))) {
	      s = ++pat;
	      while(isdigit(*pat)) pat++;
	      m = atoi(s);
	      if (m < n) {
	        i = n;
		n = m;
		m = i;
	      }
	      if (m >= max) m = max - 1;
	    }
	    pat--;
	  } else {
	    n = 1;
	    m = max - 1;
	  }
	  buf[bp++] = 0;
	  s = (char *)strcpy((char *)malloc(bp),buf);
	  pat++;
	  sav = evalwrd(pat,arg,flg,max,used);
	  if (sav) {
	    for(i=n;i <= m;i++) {
	      if ((c == '-' && flg[i]) || (c == '+' && !flg[i])) continue;
	      for(j=0;sav[j];j++) {
		if (pos == nt) tmp = (char **)realloc(tmp,sizeof(char *) * (nt += 5));
		tmp[pos] = (char *)malloc(bp+strlen(arg[i])+strlen(sav[j]));
		sprintf(tmp[pos++],"%s%s%s",s,arg[i],sav[j]);
		}
	      flg[i] = TRUE;
	    }
	    free_list(sav);  
	  } else {
	    for(i=n;i <= m;i++) {
	      if ((c == '-' && flg[i]) || (c == '+' && !flg[i])) continue;
	      if (pos == nt) tmp = (char **)realloc(tmp,sizeof(char *) * (nt += 5));
	      tmp[pos] = (char *)malloc(bp+strlen(arg[i]));
	      sprintf(tmp[pos++],"%s%s",s,arg[i]);
	      flg[i] = TRUE;
	    }
	  }
	  free(s);
	  *used = TRUE;
	  if (pos == nt) tmp = (char **)realloc(tmp,sizeof(char *) * (nt += 1));
	  tmp[pos] = NULL;
	  return tmp;
	} else if (*pat == '#') {
	  buf[bp] = 0;
	  sprintf(buf,"%s%d",buf,max);
	  bp = strlen(buf);
	  pat++;
	} else buf[bp++] = '%';
	break;
      case '\\':
	if (*pat) {
	  buf[bp++] = *pat++;
	  break;
	}
	continue;
      default:
	buf[bp++] = *(pat-1);
	break;
    }
  }
  if (!bp) {
    free(tmp);
    return NULL;
  }
  buf[bp++] = 0;
  tmp[0] = (char *)strcpy((char *)malloc(bp),buf);
  tmp[1] = NULL;
  return (char **)tmp;
}


ALIAS(n,arg,in,out,err)
int n;
char **arg;
FILE *in,*out,*err;
{
  char *tmp, **wrd;
  struct _alias *t;

  if (n == 1) {
    for(a=0;a<128;a++) {
      t = alias[a];
      while(t != NULL) {
	fprt(out,t->cmd);
	putc('\t',out);
	tmp = (char *)string(t->wrd);
	fprt(out,tmp);
	putc('\n',out);
	free(tmp);
	t = t->nxt;
      }
    }
    return 0;
  }
  if (n == 2) {
    if (isregex(arg[1])) {
      for(a=0;a<128;a++) {
	t = alias[a];
	while(t != NULL) {
	  if (patmatch(t->cmd,arg[1])) {
	    fprt(out,t->cmd);
	    putc('\t',out);
	    tmp = (char *)string(t->wrd);
	    fprt(out,tmp);
	    putc('\n',out);
	    free(tmp);
	  }
	  t = t->nxt;
	}
      }
    } else {
      if (!(t = find_alias(arg[1]))) return 1;
      fprt(out,t->cmd);
      putc('\t',out);
      tmp = (char *)string(t->wrd);
      fprt(out,tmp);
      putc('\n',out);
      free(tmp);
    }
    return 0;
  }
  tmp = (char *)malloc(strlen(arg[1])+1);
  strcpy(tmp,arg[1]);
  wrd = (char **)calloc(n-1,sizeof(char *));
  for(a=2;arg[a];a++) {
    wrd[a-2] = (char *)malloc(strlen(arg[a])+1);
    strcpy(wrd[a-2],arg[a]);
  }
  wrd[a-2] = NULL;
  add_alias(tmp,wrd);
  return 0;
}

UNALIAS(n,arg,in,out,err)
int n;
char **arg;
FILE *in,*out,*err;
{
  struct _alias *t;

  if (n == 1) return 0;
  for(a=1;arg[a];a++) {
    if (isregex(arg[a])) {
      for(b=0;b<128;b++) {
	t = alias[b];
	while(t != NULL) {
	  if (patmatch(t->cmd,arg[a])) remove_alias(t->cmd);
	  t = t->nxt;
	}
      }
    } else remove_alias(arg[a]);
  }
  return 0;
}


struct _alias *find_alias(pat)
char *pat;
{
  char i,hf = *pat & 127;
  struct _alias *p;

  p = alias[hf];

  while(p) {
    if (!(i = strcmp(pat,p->cmd))) return p;
    if (i < 0) return NULL;
    p = p->nxt;
  }
  return NULL;
}

remove_alias(pat)
char *pat;
{
  char i, hf = *pat & 127;
  struct _alias *p = alias[hf], *s;

  s = p;
  while(p) {
    if (!(i = strcmp(pat,p->cmd))) {
      if (p == alias[hf]) alias[hf] = p->nxt;
      else s->nxt = p->nxt;
      free_list(p->wrd);
      free(p->cmd);
      free(p);
      return TRUE;
    }
    if (i < 0) return FALSE;
    s = p;
    p = p->nxt;
  }
  return FALSE;
}

add_alias(cmd,wrd)
char *cmd, **wrd;
{
  char i, hf = *cmd & 127;
  struct _alias *p = alias[hf], *s, *t;

  s = p;
  while(p) {
    if (!(i = strcmp(cmd,p->cmd))) {
      free(cmd);
      free_list(p->wrd);
      p->wrd = wrd;
      return 0;
    }
    if (i < 0) break;
    s = p;
    p = p->nxt;
  }
  t = (struct _alias *)malloc(sizeof(struct _alias));
  t->cmd = cmd;
  t->wrd = wrd;
  t->nxt = p;
  if (p == alias[hf] && s == alias[hf]) alias[hf] = t;
  else s->nxt = t;
  return 0;
}
