/* Define API */
#ifndef _PKCSLLF_H_
#define _PKCSLLF_H_ 1

#ifdef __cplusplus
extern "C" {
#endif

//
// Misc Functions
//

CRYPTO_TOKEN_HANDLE PKCS_open_card(CK_CHAR_PTR, CK_STATE);

CRYPTO_TOKEN_HANDLE PKCS_init_card(CK_CHAR_PTR, CK_CHAR_PTR, CK_ULONG);

CK_RV PKCS_read_token_info(CK_CHAR_PTR, CK_TOKEN_INFO_PTR);

CK_RV PKCS_read_token_pin_info(CK_CHAR_PTR, CRYPTO_TOKEN_SECURE_INFO_PTR);

CK_RV PKCS_read_token_public_info(CK_CHAR_PTR, CRYPTO_PUBLIC_OBJECTS_PTR);

CK_RV PKCS_read_token_private_info(CK_CHAR_PTR, CRYPTO_PRIVATE_OBJECTS_PTR);

CK_RV PKCS_update_token(CK_CHAR_PTR, CRYPTO_TOKEN *);

CK_RV PKCS_write_user_pin_info(CK_CHAR_PTR, CK_CHAR_PTR, CK_ULONG);

CK_RV PKCS_write_so_pin_info(CK_CHAR_PTR, CK_CHAR_PTR, CK_ULONG);

CK_RV PKCS_write_public_info(CK_CHAR_PTR, CRYPTO_PUBLIC_OBJECTS_PTR);

CK_RV PKCS_write_private_info(CK_CHAR_PTR, CRYPTO_PRIVATE_OBJECTS_PTR);

CK_BBOOL PKCS_template_match(OBJECT_TEMPLATE_PTR, CK_ULONG, CK_ATTRIBUTE_PTR, CK_ULONG);

CK_RV PKCS_delete_object_memory(TOKEN_OBJECT_PTR);

#ifdef __cplusplus
}
#endif

#endif
