/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */


#include "rfc822.h"
#include <time.h>
#include <stdio.h>

RFC822::RFC822(const char * theRelay) {
  genId = false;
  if ((error = smtp.error) != 0) return;

  if (theRelay != NULL) {
    if ((error = smtp.setRelay(theRelay)) != 0) return;
  };

}


RFC822::~RFC822() {
}

static const char * dayName(unsigned i) {
  switch (i) {
  case 0: return "Sun";
  case 1: return "Mon";
  case 2: return "Tue";
  case 3: return "Wed";
  case 4: return "Thu";
  case 5: return "Fri";
  case 6: return "Sat";
  default: return "DDD";
  };
}

static const char * monthName(unsigned i) {
  switch (i) {
  case 0: return "Jan";
  case 1: return "Feb";
  case 2: return "Mar";
  case 3: return "Apr";
  case 4: return "May";
  case 5: return "Jun";
  case 6: return "Jul";
  case 7: return "Aug";
  case 8: return "Sep";
  case 9: return "Oct";
  case 10: return "Nov";
  case 11: return "Dec";
  default: return "MMM";
  };
}

void RFC822::optGenId(bool yes) {
  genId = yes;
}


uint32 RFC822::sendMail(const char * to, 
                        const char * from,
                        const char * subject,
                        const char * body) {
  time_t theTime;
  struct tm theTimeStruct;

  char buffer[1024];
  if ((error = smtp.openChannel(from, to)) != 0) return error;
  sprintf(buffer, "To: %s", to);
  if ((error = smtp.sendData(buffer)) != 0) return error;
  sprintf(buffer, "From: %s", from);
  if ((error = smtp.sendData(buffer)) != 0) return error;
  sprintf(buffer, "Subject: %s", subject);
  if ((error = smtp.sendData(buffer)) != 0) return error;
  time(&theTime);
  memcpy(&theTimeStruct, gmtime(&theTime), sizeof (struct tm));
  sprintf(buffer, 
          "Date: %s, %d %s %d %2.2d:%2.2d:%2.2d GMT",
          dayName(theTimeStruct.tm_wday),
          theTimeStruct.tm_mday,
          monthName(theTimeStruct.tm_mon),
          theTimeStruct.tm_year % 100,
          theTimeStruct.tm_hour,
          theTimeStruct.tm_min,
          theTimeStruct.tm_sec);
  if ((error = smtp.sendData(buffer)) != 0) return error;
  buffer[0] = 13; buffer[1] = 10; buffer[2] = 0; // CRLF seperates headers from body
  if ((error = smtp.sendData(buffer)) != 0) return error;
  if ((error = smtp.sendData(body)) != 0) return error;
  if ((error = smtp.closeChannel()) != 0) return error;

  return 0;
}
