/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

//
// Code to deal with server communication issues
//

#include <stdio.h>
#include <transports.h>

#define TCP_LISTNER	0x01
#define MAIL_LISTNER	0x02
#define WEB_LISTNER	0x03

#define DEFAULT_POLL_TIME	10800 // Three Hours
#define MSG_FLAG_SIZE		1 
#define POLL_REFERENCE_SIZE	4
#define POLL_CHECK_BACK_SIZE	4

// PKIX TCP Message flags
#define MSG_REQ		0x00
#define	POLL_REP	0x01
#define POLL_REQ	0x02
#define	NEG_POLL_REP	0x03
#define PARTIAL_MSG_REP	0x04
#define FINAL_MSG_REP	0x05
#define ERROR_MSG_REP	0x06

int
check_status(uint32 key, uint32 *status)
{
  JnhObjetectStore	objs("c:/temp/", "objs.db");
  uint32		ret;
  buffer_t		data;

  if ((ret = objs.FetchObject(key, &objClass, &data)) != 0) {
    return ret;
  }
  *status = 0;
  return 0;
}

int
pkix_msg_parse(unsigned char *msg, size_t length, uint32 *id)
{
  PKIMessage		pkiMsg;
  buffer_t		msgBuf;

  msgBuf.data = msg;
  msgBuf.data_len = length;

  if ((status - pkiMsg.read(tbuf)) != 0) {
    return status;
  }
  version = pkiMsg.header.value.pvno.get_value();
  index = pkiMsg.header.sender.selected();
  pkiMsg.header.sender.value[index].get_value(senderBuf);
  index = pkiMsg.header.recipient.selected();
  pkiMsg.header.recipeint.value[index].get_value(recipientBuf);  
  pki.header.transactionID.get_value(idBuf);
}

unit32 
process_message(unsigned char *msg, size_t length, unsigned char **reply, 
		size_t *replylen, void (*& freeRtn) (void *ptr), void *type)
{
  char		flag = 0xff;
  unit32	referenceID = 0;
  unsigned char	*pkixmsg = NULL;
  unsigned char *r;

  if (type == TCP_LISTNER) {
    switch(msg[0]) {
    case MSG_REQ:  // Contains a ASN.1 encoded PKIX message
      if ((pkixmsg = malloc(length)) == NULL) {
	panic("Memory Error");
      } 
      memset(pkixmsg, 0, length);
      memcpy(pkixmsg, msg[1], length - 1);
      status = pkix_msg_handle(pkixmsg, length - 1, &referenceID);
      memset(pkixmsg, 0, length);
      free(pkixmsg);
      switch(status) {
      case SUCCESS:
	rsize = MSG_FLAG_SIZE + POLL_REFERENCE_SIZE + POLL_CHECK_BACK_SIZE;
	if ((r = malloc(rsize)) == NULL) {
	  panic("Memory Error");
	}
	tr = r;
	*tr = POLL_REP;
	tr = tr + MSG_FLAG_SIZE;
	*tr = referenceID;
	tr = tr + POLL_REFERENCE_SIZE;
	*tr = DEFAULT_POLL_TIME;
	break;
      case SUCCESS_MESSAGE:
	break;
      case BAD_ASN1:
	break;
      case CANNOT_STORE:
	break;
      default:
	break;
      if ((r = malloc(
	panic("Memory Error");
      }
      memset(r, 
      break;
    case POLL_REQ:	// Request status
      memcpy(&referenceID, msg[1], 4);
      check_status(referenceID, &status);
      break;
    default:
      return SERVER_UNKNOWN_MSG_FLAG;
    }
    return 0;
  } else {
    fprintf(stderr, "Unknown Listner Type\n");
    return 1;
  }
}
void
start_listners(void)
{
  JnhTCPListner		tcpListner(process_message, (void *)TCP_LISTNER);
  return;
};
































































































