/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include "JonahOst.h"
#include "Init.h"



int main (int argc, char * argv[]) {

  ObjStoreData * o1;
  const ObjStoreData * o2;
  uint32 key;
  uint32 status;
  uint32 theClass;
  r_buffer_t rbuf;

  Init();

  o1 = new ObjStoreData;
  rbuf.data = (unsigned char *)"/C=us/O=no";
  rbuf.data_len = strlen((char *)rbuf.data);
  status = o1->recipient.directoryname.set_value_UTF8(rbuf);
  status = o1->recipient.select(2);
  o1->recipientURL.set_value((unsigned char *)"\0\1", 2);
  o1->transactionID.set_value((unsigned char *)"\2\3", 2);

  if (status != 0) {
    fprintf(stderr, "o->recipient.set_value returned %lu\n", status);
    goto error;
  };

  status = JnhStoreObject(o1, 42, &key);
  if (status != 0) {
    fprintf(stderr, "oc::storeObject returned %lu\n", status);
    goto error;
  };
  fprintf(stdout, "Stored value under key %ld\n", key);

  fprintf(stdout, "Locking object %ld...\n", key);
  status = JnhLockObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::LockObject returned %lu\n", status);
    goto error;
  };

  delete o1; o1 = NULL;

  fprintf(stdout, "Unlocking object %ld...\n", key);
  status = JnhUnlockObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::unlockObject returned %lu\n", status);
    goto error;
  };

  fprintf(stdout, "Locking object %ld...\n", key);
  status = JnhLockObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::LockObject returned %lu\n", status);
    goto error;
  };

  fprintf(stdout, "Getting for modify object %ld...\n", key);
  status = JnhGetObjectModify(key, &theClass, &o1);
  if (status != 0) {
    fprintf(stderr, "oc::GetObjectModify returned %lu\n", status);
    goto error;
  };

  fprintf(stdout, "Unlocking object %ld...\n", key);
  status = JnhUnlockObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::unlockObject returned %lu\n", status);
    goto error;
  };


  fprintf(stdout, "Locking object %ld...\n", key);
  status = JnhLockObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::LockObject returned %lu\n", status);
    goto error;
  };

  fprintf(stdout, "Getting for modify object %ld...\n", key);
  status = JnhGetObjectModify(key, &theClass, &o1);
  if (status != 0) {
    fprintf(stderr, "oc::GetObjectModify returned %lu\n", status);
    goto error;
  };
  
  rbuf.data = (unsigned char *)"/C=us/O=Yes";
  rbuf.data_len = strlen((char *)rbuf.data);
  status = o1->recipient.directoryname.set_value_UTF8(rbuf);
  
  fprintf(stdout, "Synching object %ld...\n", key);
  status = JnhSynchObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::SynchObject returned %lu\n", status);
    goto error;
  };
  
  
  fprintf(stdout, "Locking object %ld...\n", key);
  status = JnhLockObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::LockObject returned %lu\n", status);
    goto error;
  };

  fprintf(stdout, "Getting for modify object %ld...\n", key);
  status = JnhGetObjectModify(key, &theClass, &o1);
  if (status != 0) {
    fprintf(stderr, "oc::GetObjectModify returned %lu\n", status);
    goto error;
  };
  
  rbuf.data = (unsigned char *)"/C=us/O=Maybe";
  rbuf.data_len = strlen((char *)rbuf.data);
  status = o1->recipient.directoryname.set_value_UTF8(rbuf);
  
  fprintf(stdout, "Synching object %ld...\n", key);
  status = JnhSynchObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::SynchObject returned %lu\n", status);
    goto error;
  };
  

  
  fprintf(stdout, "Locking object %ld...\n", key);
  status = JnhLockObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::LockObject returned %lu\n", status);
    goto error;
  };

  fprintf(stdout, "Getting for modify object %ld...\n", key);
  status = JnhGetObjectModify(key, &theClass, &o1);
  if (status != 0) {
    fprintf(stderr, "oc::GetObjectModify returned %lu\n", status);
    goto error;
  };
  
  rbuf.data = (unsigned char *)"/C=us/O=Probably not";
  rbuf.data_len = strlen((char *)rbuf.data);
  status = o1->recipient.directoryname.set_value_UTF8(rbuf);
  
  fprintf(stdout, "Discarding object %ld...\n", key);
  status = JnhDiscardObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::DiscardObject returned %lu\n", status);
    goto error;
  };
  


    fprintf(stdout, "Locking object %ld...\n", key);
  status = JnhLockObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::LockObject returned %lu\n", status);
    goto error;
  };

  fprintf(stdout, "Getting for object %ld...\n", key);

  status = JnhGetObject(key, &theClass, &o2);
  if (status != 0) {
    fprintf(stderr, "oc::GetObject returned %lu\n", status);
    goto error;
  };
  
  rbuf.data = (unsigned char *)"/C=us/O=Probably not";
  rbuf.data_len = strlen((char *)rbuf.data);
  status = o1->recipient.directoryname.set_value_UTF8(rbuf);
  
  fprintf(stdout, "Unlocking object %ld...\n", key);
  status = JnhUnlockObject(key);
  if (status != 0) {
    fprintf(stderr, "oc::DiscardObject returned %lu\n", status);
    goto error;
  };
  


  return EXIT_SUCCESS;
error:
  if (o1) delete o1;
  return EXIT_FAILURE;
}
