/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <platform.h>
#include <slindex.h>

#ifdef _WIN32
#include <winsock2.h>
#else
#include <sockets.h>
#endif

typedef struct {
  char ident[32];
  char indexName[16];
  uint32 keySize;
  char dataFileName[256];
} index_header_val_t;

typedef struct {
  index_header_val_t val;
  unsigned char padding[512-sizeof(index_header_val_t)];
} index_header_t;




typedef struct {
  char ident[32];
  uint32 maxLevels;
  uint32 currentMax;
  uint32 root;
} slheader_val_t;

typedef struct {
  slheader_val_t val;
  unsigned char padding[64-sizeof(slheader_val_t)];
} slheader_t;



static char s_ident[32] = "Jonah Index File V1.0\n";

static char sl_ident[32] = "Jonah Skip-list Index V1.0\n";

int main(int argc, char * argv[]) {
  FILE * index_file;

  index_header_t index_header;
  slheader_t sl_header;
  uint32 keySize;
  uint32 maxLevels;
  int i;
  int j;
  slnode_t * node;


  long file_offset = 0;

  if (argc != 2) {
    fprintf(stderr, "Usage: indexview <file>\n");
    return EXIT_FAILURE;
  };
  index_file = fopen(argv[1], "rb");
  if (index_file == NULL) {
    fprintf(stderr, "Error opening %s for reading\n", argv[1]);
    return EXIT_FAILURE;
  };

  if (fread(&index_header, sizeof(index_header), 1, index_file) != 1) {
    fprintf(stderr, "Error reading index header: insufficient data in file\n");
    return EXIT_FAILURE;
  };

  if (memcmp(index_header.val.ident, s_ident, 32) != 0) {
    fprintf(stderr, "Error: Ident incorrect\n");
    fprintf(stderr, "Expected: \"%s\"\n", s_ident);
    fprintf(stderr, "Found:    \"%s\"\n", index_header.val.ident);
    return EXIT_FAILURE;
  };

  keySize = ntohl(index_header.val.keySize);
  fprintf(stdout, "Opened file.  Properties:\n");
  fprintf(stdout, "Ident: %s", index_header.val.ident);
  fprintf(stdout, "Index Name: \"%s\"\n", index_header.val.indexName);
  fprintf(stdout, "Key Size: \"%lu\"\n", keySize);
  fprintf(stdout, "Data File: \"%s\"\n", index_header.val.dataFileName);
  fprintf(stdout, "---\n");

  if (fread(&sl_header, sizeof(sl_header), 1, index_file) != 1) {
    fprintf(stderr, "Error reading SkipList header: insufficient data in file\n");
    return EXIT_FAILURE;
  };

  if (memcmp(sl_header.val.ident, sl_ident, 32) != 0) {
    fprintf(stderr, "Error: Ident incorrect\n");
    fprintf(stderr, "Expected: \"%s\"\n", sl_ident);
    fprintf(stderr, "Found:    \"%s\"\n", sl_header.val.ident);
    return EXIT_FAILURE;
  };

  maxLevels = ntohl(sl_header.val.maxLevels);
  fprintf(stdout, "SubIdent: %s", sl_header.val.ident);
  fprintf(stdout, "Max levels: %ld\n", maxLevels);
  fprintf(stdout, "Levels used: %ld\n", ntohl(sl_header.val.currentMax));
  fprintf(stdout, "Root: %ld\n", ntohl(sl_header.val.root));
  fprintf(stdout, "---\n");


  node = new slnode_t(maxLevels, keySize);


  file_offset = ftell(index_file);
  while (node->read(index_file) == 0) {
    fprintf(stdout, "\nNode %lu\n", file_offset - sizeof(index_header) - sizeof(sl_header));
    fprintf(stdout, "   Level: %lu\n", node->level);
    fprintf(stdout, "   Key: ");
    for (i=0; i<keySize; i++) fprintf(stdout, "%2.2X", node->key[i]);
    fprintf(stdout, "\n");
    fprintf(stdout, "   Data: %lu\n", node->data);
    for (i=0; i<node->level; i++) {
      fprintf(stdout, "   Ptr[%d]: %lu (Key ", i, node->ptrs[i]);
      for (j=0; j<keySize; j++) fprintf(stdout, "%2.2X", node->keys[j+(keySize*i)]);
      fprintf(stdout, ")\n");
    };

    file_offset = ftell(index_file);
  };







  fprintf(stdout, "Dump complete\n\n"); 
  return EXIT_SUCCESS;

}