/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef PKI_QD_XPG_
#define PKI_QD_XPG_

#include <string.h>
#include <stdio.h>
#include <pkiMsg.h>
#ifdef BOOTSTRAP
#include "bootstrap_xpgmsg.h"
#else
#include "xpgmsg.h"
#endif

#define MAX_MSG_SIZE 1024

class msg_header_t {
public:
  uint32 majic;
  int id;
  char mnemonic[64];
  uint32 length;
  msg_header_t(void) {
    majic = 27;
    id = 0;
    length = 0;
  };
  bool operator == (const msg_header_t & o) const;
  bool operator != (const msg_header_t & o) const;
};

class set_header_t {
public:
  uint32 majic;
  int id;
  char mnemonic[64];
  set_header_t(void) {
    majic = 42;
    id = 0;
  };
  bool operator == (const set_header_t & o) const;
  bool operator != (const set_header_t & o) const;
};

class cat_header_t {
public:
  uint32 majic;
  char name[512];
  cat_header_t(void) {
    majic = 35;
    memset(name, 0, sizeof(name));
  };
  bool operator == (const cat_header_t & o) const;
  bool operator != (const cat_header_t & o) const;
};

class xpg_msglist_t {
friend class xpg_setlist_t;
friend class xpg_catalog_t;
protected:
  xpg_msglist_t(const msg_header_t & h, FILE * f);
  xpg_msglist_t(int id, const char * msgText, const char * mn = NULL);
  uint32 write(FILE * f);
  uint32 genHeader(FILE * f, int setId);
public:
  xpg_msglist_t * next;
  msg_header_t header;
  char * text;
  xpg_msglist_t(void) {
    next = NULL;;
    memset(&header, 0, sizeof(header));
    text = NULL;
  };
};

class xpg_setlist_t {
friend class xpg_catalog_t;
protected:
  xpg_setlist_t(const set_header_t & h, FILE * f);
  xpg_setlist_t(int id, const char * mn = NULL);
  uint32 write(FILE * f);
  uint32 genHeader(FILE * f);
public:
  xpg_setlist_t * next;
  set_header_t header;
  xpg_msglist_t * msgs;
  xpg_setlist_t(void) {
    next = NULL;
    memset(&header, 0, sizeof(header));
    msgs = NULL;
  };
};

class xpg_catalog_t {
protected:
  static xpg_catalog_t * root;
public:
  xpg_catalog_t * next;
  pki_msgcat_handle_t id;
  cat_header_t header;
  xpg_setlist_t * set;
  xpg_catalog_t(void) {
    next = NULL;
    id = 0;
    memset(&header, 0, sizeof(header));
    set = NULL;
  };
  static const char * lookupMessage(pki_msgcat_handle_t h, int set, int msg);
  static pki_msgcat_handle_t createCatalog(const char * name);

  static uint32 defineMessage(pki_msgcat_handle_t h, 
                              const char * setName, 
                              const char * msgName,
                              const char * text,
                              int & set,
                              int & msg);
  static pki_msgcat_handle_t read(FILE * f);
  static uint32 write(pki_msgcat_handle_t h, FILE * f);
  static uint32 genHeader(pki_msgcat_handle_t h, const char * ident, FILE * f);
  static uint32 display(void); // For debugging - dumps the catalog to stdout.
};


#endif
