/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

//-----------------------------------------------------------------------
//
//      File Name:              scfunc.h
//
//      Description:    Smart Card functions include file           
//
//      Author:         Michael A. Crane
//
//      Version:                1.0
//
//      Comments:
//
//      Change Flags:
//
//              MAC000  08/08/98        Original Code   
//
//-----------------------------------------------------------------------

#ifndef _SCFUNC_H_
#define _SCFUNC_H_ 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _DEBUG

#define DEBUG_MSG(STR)                printf(STR);
#define DEBUG_INFO(STR, DATA)         printf(STR, DATA);
#define DEBUG_INFO2(STR, DATA, DATA2) printf(STR, DATA, DATA2);

#else

#define DEBUG_MSG(STR)                              
#define DEBUG_INFO(STR, DATA)                              
#define DEBUG_INFO2(STR, DATA, DATA2)                            

#endif

#include <stdio.h> 
#if defined(AIX)
#include <stdlib.h>
#endif

#include "pkcsvsc.h"


#define MAX_HANDLES             256
#define BUF_SIZE                        4096
#define TOKEN_APPLICATION       "PKIX"
#define TOKEN_LABEL             "KEYSLOT"

#if defined (UNIX)

#include <sys/time.h>

typedef struct timeval TIMEVALUE;
#define ELAPSED(before,after,elapsed) \
	{\
		if (before.tv_usec > after.tv_usec)\
		{\      
			after.tv_usec += 1000000;\
			after.tv_sec--;\
		}\
		elapsed = (after.tv_sec-before.tv_sec) * 1000 + \
			      (after.tv_usec-before.tv_usec) / 1000;\
	}

#elif defined (WIN32)

#ifndef JONAH
#include <mmsystem.h>
#else
#include <windows.h>
#endif

#define ELAPSED(before,after,elapsed) {elapsed=after-before;}
#define gettimeofday(time,timezone) {*(time)=timeGetTime();}
typedef DWORD TIMEVALUE;

#endif

#ifdef JONAH
#include <platform.h>
#else
#define EXPORTFN(a,b,c) a b c
#endif

#define gets(data) {fflush(stdin);gets(data);}

EXPORTFN(uint32,
	 scInit,
	 (CSSM_MEMORY_FUNCS& memoryFuncs));

EXPORTFN(uint32,
	 scInitializeCard,
	 (const char * current_pin, 
	  const char * newpin));

EXPORTFN(uint32,
	 scChangeSOPin,
	 (const char * current_pin, 
	  const char *newpin));

EXPORTFN(uint32,
	 scChangeUserPin,
	 (const char * current_pin, 
	  const char * newpin));

EXPORTFN(uint32,
	 scSetUserPin,
	 (const char * sopin, 
	  const char * userpin));

EXPORTFN(uint32,
	 scIsTokenInitialized,
	   (void * ptr
	   ));

#ifdef __cplusplus

EXPORTFN(uint32,
	 scCreateCertificate,
	 (const char * ppin,
	  const utf8String psubject,
	  const utf8String pissuer,
	  uint32 version,
	  const r_buffer_t & serial,
	  const r_buffer_t & pubkey));

EXPORTFN(uint32,
	 scCreateKeySlot,
	 (const char * pin, 
	  const utf8String subject,
	  const utf8String issuer,
	  uint32 version,
	  const r_buffer_t & serial,
	  const r_buffer_t & private_key,
	  const r_buffer_t & cert));

EXPORTFN(uint32,
	 scRetrieveKeySlot,
	 (const char * pin, 
	  const utf8String subject, 
	  const utf8String issuer, 
	  uint32 & version, 
	  buffer_t * serial, 
	  buffer_t * private_key, 
	  buffer_t * cert ));

EXPORTFN(uint32,
	 scUpdateKeySlot,
	 (const char * pin, 
	  const utf8String subject,
	  const utf8String issuer,
	  uint32 version,
	  const r_buffer_t & serial,
	  const r_buffer_t & private_key,
	  const r_buffer_t & cert));

#endif

#ifndef SC_ERROR
#define SC_ERROR

#define SC_OK                                   0
#define SC_MEMORY_FUNCTION_UNDEFINED    -900
#define SC_MODULE_ATTACH_ERROR          -901
#define SC_MODULE_DETACH_ERROR          -902
#define SC_LOGIN_ERROR                          -903
#define SC_LOGOUT_ERROR                         -904
#define SC_MODULE_INFO_ERROR                    -905
#define SC_FREE_MODULE_INFO_ERROR               -906
#define SC_INITIALIZATION_ERROR         -907
#define SC_SET_USER_PIN_ERROR                   -908
#define SC_CHANGE_USER_PIN_ERROR                -909
#define SC_CHANGE_SO_PIN_ERROR          -910
#define SC_CLOSE_ALL_SESSIONS_ERROR             -911
#define SC_DB_OPEN_ERROR                        -912
#define SC_DB_CLOSE_ERROR                       -913
#define SC_PRIVATE_KEY_INSERT_ERROR             -914
#define SC_PRIVATE_KEY_READ_ERROR               -915
#define SC_CERTIFICATE_INSERT_ERROR             -916
#define SC_SESSION_ID_INVALID                   -917
#define SC_FREE_ATTRIBUTES_ERROR                -918
#define SC_INVALID_VERSION                      -919
#define SC_CDSA_RECORD_ATTRIBUTES_ERROR -920
#define SC_KEYSLOT_INVALID_PARAMETER    -921
#define SC_KEYRETRIEVE_INVALID_PARAMETER        -922
#define SC_KEYUPDATE_INVALID_PARAMETER  -923
#define SC_SESSION_LIMIT                        -924
#define SC_KEY_CONTEXT_ERROR                    -925
#define SC_KEY_MEMORY_ERROR                     -926
#define SC_PRIVATE_KEY_DELETE_ERROR             -927



#endif

#ifdef __cplusplus
}
#endif

#endif
