/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef PLATFORM_DEPENDENCIES_H_
#define PLATFORM_DEPENDENCIES_H_

# ifdef _WIN32
#  define OS WIN32

#  define POINTERS_FIT_IN_UINT32

#  ifndef INT_TYPES_DEFINED_
#   define INT_TYPES_DEFINED_
    typedef unsigned char uint8;
#if (_MSC_VER == 1200) // Visual C++ V6.0 is busted
    typedef unsigned int uint32;
    typedef int sint32;
    typedef short sint16;
    typedef unsigned short uint16;
#else 
    typedef unsigned __int32 uint32;
    typedef __int32 sint32;
    typedef unsigned __int16 uint16;
    typedef __int16 sint16;
#endif
#  endif

#  define NEED_XPG_PRINTF
#  define NEED_XPG_MESSAGES


#  define APILINKAGE __cdecl

#  define EXPORTFN(rtype, fn, params) __declspec( dllexport ) rtype fn params
#  define IMPORTFN(rtype, fn, params) __declspec( dllimport ) rtype fn params

#  define EXPORTCLASS __declspec( dllexport ) 
#  define IMPORTCLASS __declspec( dllimport ) 

#  define DIR_SEP_CHARACTER '\\'

#  ifdef _M_IX86

#   define MACHINE IX86

#  else

#  endif

# else

/* Default settings for 32-bit Unix systems */

#  define POINTERS_FIT_IN_UINT32

#  ifndef INT_TYPES_DEFINED_
#   define INT_TYPES_DEFINED_
    typedef unsigned int uint32;
    typedef int sint32;
    typedef unsigned short uint16;
    typedef short sint16;
#  endif

#  define APILINKAGE

#  define DIR_SEP_CHARACTER '/'

# endif


# define PLATFORM OS##_##MACHINE

/* 
 * The remainder of this file provides default definitions for essential
 * symbols if they don't have platform-specific definitions.
 */


# ifndef EXPORTFN
#  define EXPORTFN(rtype, fn, params)
# endif

# ifndef IMPORTFN
#  define IMPORTFN(rtype, fn, params)
# endif

# ifndef EXPORTCLASS 
#  define EXPORTCLASS
# endif

# ifndef IMPORTCLASS
#  define IMPORTCLASS
# endif

# ifndef APILINKAGE
#  define APILINKAGE
# endif


# ifndef DIR_SEP_CHARACTER
#  define DIR_SEP_CHARACTER '/'
# endif

#  ifndef INT_TYPES_DEFINED_
#   define INT_TYPES_DEFINED_
    typedef unsigned int uint32;
    typedef int sint32;
    typedef unsigned short uint16;
    typedef short sint16;
#  endif


typedef unsigned char * utf8String;


#endif
