/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */



#ifndef __CRYPTO_H__
#define __CRYPTO_H__ 1

#include <cssm.h>
#include <platform.h>
#include <asnbase.h>
#include <x509.h>

enum p12keytype_t {NONE, ENCRYPTION, IV, MAC};

#ifdef not_used
EXPORTFN(uint32, JnhCryptoInitialize, (void));
EXPORTFN(uint32, CR_SHA1, (const CSSM_DATA_PTR in, CSSM_DATA &out));
EXPORTFN(uint32, CR_GenerateRSAKey, 
	 (uint32 keysize, CSSM_KEY &publicKey, CSSM_KEY &privateKey));
EXPORTFN(uint32, CR_RSASignWithSHA1, (CSSM_KEY key, const CSSM_DATA_PTR data, 
				      CSSM_DATA &signature));
EXPORTFN(uint32, CR_SHA1WithRSAVerify, (CSSM_KEY key, const CSSM_DATA_PTR data,
					const CSSM_DATA_PTR signature, 
					bool &isVerified));

#endif
EXPORTFN(int, CR_InitKeyAccess, (void));
EXPORTFN(uint32, CR_HMACWithSHA1, (buffer_t &data, buffer_t &key, 
				   buffer_t &mac));
EXPORTFN(int, CR_DigestData, (CSSM_ALGORITHMS &alg, r_buffer_t &inbuff, buffer_t &outbuff));

EXPORTFN(int, CR_GetMyCert, (x509_certificate &mycert)); 

EXPORTFN(int, CR_SignData, (AlgorithmIdentifier &alg, r_buffer_t tosign, buffer_t &signature));

EXPORTFN(int, CR_SetPin, (const utf8String newpin)); 

EXPORTFN(uint32, CR_PKCS12_makekey, (utf8String password,const buffer_t &salt, 
				     p12keytype_t type, long iteration, 
				     unsigned int keysize, buffer_t &key));

EXPORTFN(uint32, CR_PKCS12_generate_salt, (buffer_t &salt));

EXPORTFN(uint32, CR_PKCS12_DecryptContent, (const buffer_t &alg, 
					   const buffer_t &salt, 
					   long iteration, utf8String password,
					   const r_buffer_t in, 
					   buffer_t &out));

#endif
