/* SCCSID: inc/ibmswcsp.h, dss_cdsa_fwk, fwk_rel2, dss_980303 1.13 3/5/98 14:17:20 */
/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*
 * (C) COPYRIGHT International Business Machines Corp. 1996, 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */

#ifndef __IBMSWCSP_H
#define __IBMSWCSP_H

#include "cssm.h"

/*
 *  Version numbers
 */

#define IBMSWCSP_MAJOR_VERSION        1
#define IBMSWCSP_MINOR_VERSION        0


/*
 *  GUID
 */

/* dda0c1e0-7b73-11d0-8e0c-0004ac602b18 */
#define IBMSWCSP_GUID {0xdda0c1e0, 0x7b73, 0x11d0, {0x8e, 0x0c, 0x00, 0x04, 0xac, 0x60, 0x2b, 0x18}}


/*
 *  RSA public exponents used when generating key pair
 */

#define IBMSWCSP_RSAF0          {0x03}
#define IBMSWCSP_RSAF4          {0x01, 0x00, 0x01}


/* 
 *  IBMSWCSP specific return codes
 */

#define IBMSWCSP_ALGORITHM_ALREADY_SET        (CSSM_CSP_PRIVATE_ERROR + 0x0200)
#define IBMSWCSP_ALGORITHM_INFO           (CSSM_CSP_PRIVATE_ERROR + 0x0201)
#define IBMSWCSP_ALGORITHM_NOT_INITIALIZED      (CSSM_CSP_PRIVATE_ERROR + 0x0202)
#define IBMSWCSP_ALGORITHM_NOT_SET          (CSSM_CSP_PRIVATE_ERROR + 0x0203)
#define IBMSWCSP_ALGORITHM_OBJ            (CSSM_CSP_PRIVATE_ERROR + 0x0204)
#define IBMSWCSP_ALG_OPERATION_UNKNOWN        (CSSM_CSP_PRIVATE_ERROR + 0x0205)
#define IBMSWCSP_ALLOC                (CSSM_CSP_PRIVATE_ERROR + 0x0206)
#define IBMSWCSP_CANCEL               (CSSM_CSP_PRIVATE_ERROR + 0x0207)
#define IBMSWCSP_DATA               (CSSM_CSP_PRIVATE_ERROR + 0x0208)
#define IBMSWCSP_EXPONENT_EVEN            (CSSM_CSP_PRIVATE_ERROR + 0x0209)
#define IBMSWCSP_EXPONENT_LEN           (CSSM_CSP_PRIVATE_ERROR + 0x020a)
#define IBMSWCSP_HARDWARE             (CSSM_CSP_PRIVATE_ERROR + 0x020b)
#define IBMSWCSP_INPUT_DATA             (CSSM_CSP_PRIVATE_ERROR + 0x020c)
#define IBMSWCSP_INPUT_LEN              (CSSM_CSP_PRIVATE_ERROR + 0x020d)
#define IBMSWCSP_KEY_ALREADY_SET          (CSSM_CSP_PRIVATE_ERROR + 0x020e)
#define IBMSWCSP_KEY_INFO             (CSSM_CSP_PRIVATE_ERROR + 0x020f)
#define IBMSWCSP_KEY_LEN              (CSSM_CSP_PRIVATE_ERROR + 0x0210)
#define IBMSWCSP_KEY_NOT_SET            (CSSM_CSP_PRIVATE_ERROR + 0x0211)
#define IBMSWCSP_KEY_OBJ              (CSSM_CSP_PRIVATE_ERROR + 0x0212)
#define IBMSWCSP_KEY_OPERATION_UNKNOWN        (CSSM_CSP_PRIVATE_ERROR + 0x0213)
#define IBMSWCSP_MEMORY_OBJ             (CSSM_CSP_PRIVATE_ERROR + 0x0214)
#define IBMSWCSP_MODULUS_LEN            (CSSM_CSP_PRIVATE_ERROR + 0x0215)
#define IBMSWCSP_NOT_INITIALIZED          (CSSM_CSP_PRIVATE_ERROR + 0x0216)
#define IBMSWCSP_NOT_SUPPORTED            (CSSM_CSP_PRIVATE_ERROR + 0x0217)
#define IBMSWCSP_OUTPUT_LEN             (CSSM_CSP_PRIVATE_ERROR + 0x0218)
#define IBMSWCSP_OVER_32K             (CSSM_CSP_PRIVATE_ERROR + 0x0219)
#define IBMSWCSP_RANDOM_NOT_INITIALIZED       (CSSM_CSP_PRIVATE_ERROR + 0x021a)
#define IBMSWCSP_RANDOM_OBJ             (CSSM_CSP_PRIVATE_ERROR + 0x021b)
#define IBMSWCSP_SIGNATURE              (CSSM_CSP_PRIVATE_ERROR + 0x021c)
#define IBMSWCSP_WRONG_ALGORITHM_INFO       (CSSM_CSP_PRIVATE_ERROR + 0x021d)
#define IBMSWCSP_WRONG_KEY_INFO           (CSSM_CSP_PRIVATE_ERROR + 0x021e)
#define IBMSWCSP_INPUT_COUNT            (CSSM_CSP_PRIVATE_ERROR + 0x021f)
#define IBMSWCSP_OUTPUT_COUNT           (CSSM_CSP_PRIVATE_ERROR + 0x0220)
#define IBMSWCSP_METHOD_NOT_IN_CHOOSER        (CSSM_CSP_PRIVATE_ERROR + 0x0221)
#define IBMSWCSP_KEY_WEAK             (CSSM_CSP_PRIVATE_ERROR + 0x0222)


#endif
