/* SCCSID: inc/cssmcli.h, dss_cdsa_fwk, fwk_rel3, dss_980403 1.5 4/13/98 10:38:21 */
/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

/*
 * (C) COPYRIGHT International Business Machines Corp. 1996, 1997
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * Copyright (c) 1995, 1996, 1997 Intel Corporation. All rights reserved.
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */

#ifndef _CSSMCLI_H
#define _CSSMCLI_H    

#include "cssmtype.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct cssm_spi_cl_funcs {
    CSSM_DATA_PTR (CSSMAPI *CertSign)  (CSSM_CL_HANDLE CLHandle, 
                                        CSSM_CC_HANDLE CCHandle, 
                                        const CSSM_DATA_PTR SubjectCert, 
                                        const CSSM_DATA_PTR SignerCert, 
                                        const CSSM_FIELD_PTR SignScope, 
                                        uint32 ScopeSize);
    CSSM_BOOL     (CSSMAPI *CertVerify)(CSSM_CL_HANDLE CLHandle, 
                                        CSSM_CC_HANDLE CCHandle, 
                                        const CSSM_DATA_PTR SubjectCert, 
                                        const CSSM_DATA_PTR SignerCert, 
                                        const CSSM_FIELD_PTR VerifyScope,
                                        uint32 ScopeSize);
    CSSM_DATA_PTR (CSSMAPI *CertCreateTemplate)
                                            (CSSM_CL_HANDLE CLHandle, 
                                             const CSSM_FIELD_PTR CertTemplate, 
                                             uint32 NumberOfFields);
    CSSM_DATA_PTR  (CSSMAPI *CertGetFirstFieldValue) 
                                       (CSSM_CL_HANDLE CLHandle, 
                                        const CSSM_DATA_PTR Cert, 
                                        const CSSM_OID_PTR CertField,
                                        CSSM_HANDLE_PTR ResultsHandle,
                                        uint32 *NumberOfMatchedFields);
    CSSM_DATA_PTR  (CSSMAPI *CertGetNextFieldValue) 
                                       (CSSM_CL_HANDLE CLHandle, 
                                        CSSM_HANDLE ResultsHandle);
    CSSM_RETURN    (CSSMAPI *CertAbortQuery) 
                                       (CSSM_CL_HANDLE CLHandle, 
                                        CSSM_HANDLE ResultsHandle);
    CSSM_KEY_PTR   (CSSMAPI *CertGetKeyInfo) 
                                       (CSSM_CL_HANDLE CLHandle, 
                                        const CSSM_DATA_PTR Cert);
    CSSM_FIELD_PTR (CSSMAPI *CertGetAllFields) 
                                       (CSSM_CL_HANDLE CLHandle,
                                        const CSSM_DATA_PTR Cert,
                                        uint32 *NumberOfFields);
    CSSM_DATA_PTR (CSSMAPI *CertImport)(CSSM_CL_HANDLE CLHandle, 
                                        CSSM_CERT_TYPE ForeignCertType, 
                                        const CSSM_DATA_PTR ForeignCert); 
    CSSM_DATA_PTR (CSSMAPI *CertExport)(CSSM_CL_HANDLE CLHandle, 
                                        CSSM_CERT_TYPE TargetCertType, 
                                        const CSSM_DATA_PTR NativeCert);
    CSSM_OID_PTR  (CSSMAPI *CertDescribeFormat) 
                                       (CSSM_CL_HANDLE CLHandle,
                                        uint32 *NumberOfFields);
    CSSM_DATA_PTR (CSSMAPI *CrlCreateTemplate) (CSSM_CL_HANDLE CLHandle, 
                                               const CSSM_FIELD_PTR CrlTemplate,
                                               uint32 NumberOfFields);
    CSSM_DATA_PTR (CSSMAPI *CrlSetFields)  (CSSM_CL_HANDLE CLHandle,
                                            const CSSM_FIELD_PTR CrlTemplate,
                                            uint32 NumberOfFields,
                                            const CSSM_DATA_PTR OldCrl);
    CSSM_DATA_PTR (CSSMAPI *CrlAddCert)(CSSM_CL_HANDLE CLHandle, 
                                        CSSM_CC_HANDLE CCHandle, 
                                        const CSSM_DATA_PTR Cert, 
                                        const CSSM_DATA_PTR RevokerCert, 
                                        CSSM_REVOKE_REASON RevokeReason, 
                                        const CSSM_DATA_PTR OldCrl);
    CSSM_DATA_PTR (CSSMAPI *CrlRemoveCert) 
                                       (CSSM_CL_HANDLE CLHandle, 
                                        const CSSM_DATA_PTR Cert, 
                                        const CSSM_DATA_PTR OldCrl);
    CSSM_DATA_PTR (CSSMAPI *CrlSign)   (CSSM_CL_HANDLE CLHandle, 
                                        CSSM_CC_HANDLE CCHandle, 
                                        const CSSM_DATA_PTR UnsignedCrl, 
                                        const CSSM_DATA_PTR SignerCert, 
                                        const CSSM_FIELD_PTR SignScope,
                                        uint32 ScopeSize);
    CSSM_BOOL     (CSSMAPI *CrlVerify) (CSSM_CL_HANDLE CLHandle, 
                                        CSSM_CC_HANDLE CCHandle, 
                                        const CSSM_DATA_PTR SubjectCrl, 
                                        const CSSM_DATA_PTR SignerCert,
                                        const CSSM_FIELD_PTR VerifyScope,
                                        uint32 ScopeSize);
    CSSM_BOOL     (CSSMAPI *IsCertInCrl)(CSSM_CL_HANDLE CLHandle, 
                                        const CSSM_DATA_PTR Cert, 
                                        const CSSM_DATA_PTR Crl);
    CSSM_DATA_PTR (CSSMAPI *CrlGetFirstFieldValue) 
                                       (CSSM_CL_HANDLE CLHandle, 
                                        const CSSM_DATA_PTR Crl,
                                        const CSSM_OID_PTR CrlField,
                                        CSSM_HANDLE_PTR ResultsHandle,
                                        uint32 *NumberOfMatchedFields);
    CSSM_DATA_PTR (CSSMAPI *CrlGetNextFieldValue) 
                                       (CSSM_CL_HANDLE CLHandle, 
                                        CSSM_HANDLE ResultsHandle);
    CSSM_RETURN   (CSSMAPI *CrlAbortQuery) 
                                       (CSSM_CL_HANDLE CLHandle, 
                                        CSSM_HANDLE ResultsHandle);
    CSSM_OID_PTR  (CSSMAPI *CrlDescribeFormat) 
                                       (CSSM_CL_HANDLE CLHandle,
                                        uint32 *NumberOfFields);
    void * (CSSMAPI *PassThrough)(CSSM_CL_HANDLE CLHandle, 
                                        CSSM_CC_HANDLE CCHandle, 
                                        uint32 PassThroughId, 
                                        const void * InputParams);
} CSSM_SPI_CL_FUNCS, *CSSM_SPI_CL_FUNCS_PTR;

#ifdef __cplusplus
}
#endif

#endif
