/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef OBJECTSTORE_H_
#define OBJECTSTORE_H_

#include <asnbase.h>
#include <pkiTask.h>
#include <qdisam.h>
#include <ObjStates.h>

typedef enum {
  OS_OPEN,
  OS_ERROR,
  OS_CLOSED
} os_state_t;

// The JnhObjectStore class represents a weakly-typed database of 
// objects.  Objects within the database have an integer key, an
// integer "objectClass", and a BLOB value.  By convention, the 
// objectClass is a composition of an ObjStXXX value and an 
// ObjTypeXXX value.
//
// Other than the constructor, all member functions may be called
// from multiple threads, and will handle their own synchronization.


class EXPORTCLASS JnhObjectStore {
private:
  pki_mutex_t mutex;
  char dbName[1024];
  char dbDir[1024];
  isam * db;
  os_state_t state;
  uint32 error;
public:
  os_state_t getState(void);
  uint32 getError(void);
  JnhObjectStore(const char * dbDir, 
                 const char * dbName, 
                 uint32 active_objects = 512,
                 uint32 object_size = 1024);
// Creating an objectstore requires the name of the underlying 
// on-disk database, and an estimate of the number and size of 
// objects that need to be stored.
  ~JnhObjectStore();
  
  uint32 CreateObject(uint32 * key, uint32 objClass, r_buffer_t data);
// Create an object with data

  uint32 StoreObject(uint32 key, 
                     uint32 objClass, r_buffer_t data);
// Store an object under a key.  The key must have been obtained from
// the ObjectStore by a previous CreateObject or ListObjects call.

  uint32 FetchObject(uint32 key, 
                     uint32 & objClass, buffer_t & data);
// Fetch an object by its key

  uint32 DeleteObject(uint32 key);
// Delete an object by its key.

  uint32 ListActiveObjects(void (* callback)(uint32 key, 
                                             uint32 objClassSt));
// Run through the database, calling <callback> for every object whose 
// objClass is active

  uint32 ListSurrogateObjects(void (* callback)(uint32 key, 
                                                uint32 objClassSt));
// Run through the database, calling <callback> for every object whose 
// objClass is surrogate

  uint32 ListObjectsByClass(uint32 objClass,
                            void (* callback)(uint32 key, 
                                              uint32 objClassSt));
// Run through the database, calling <callback> for every object
// whose objClass intersects the specified class (masked with ObjClAll)

  uint32 ListObjectsByState(uint32 objState,
                            void (* callback)(uint32 key, 
                                              uint32 objClassSt));
// Run through the database, calling <callback> for every object
// whose state matches the specified state (masked with ObjStAll)


  uint32 ListKeysByMatch(uint32 value,
                         uint32 mask,
                         buffer_t & results);
// Run through the database, looking for objects for which 
// objClass & mask == value.  For each object found, an
// entry will be made in the results buffer, consisting of 
// the uint32 key of the object in native byte-order. 
// This routine is provided to support the BiniFile function; 
// it is not intended to be used by the "real" objectStore.
 
  uint32 ListKeysByBits(uint32 mask,
                        buffer_t & results);
// Run through the database, looking for objects for which
// objClass & mask is non-zero.  For each object found, an
// entry will be made in the results buffer, consisting of 
// the uint32 key of the object in native byte-order. 
// This routine is provided to support the BiniFile function; 
// it is not intended to be used by the "real" objectStore.
  

  

};


#endif
