/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef OBJ_STATES_H_
#define OBJ_STATES_H_

/* An object state, or objClass, is composed from   */
/* several fields.  The state itself is an integer, */
/* and is stored in the high-order sixteen bits of  */
/* the objClass.  General properties of the state   */
/* are stored in a series of bit-fields in the      */
/* low-order sixteen bits, and these general        */
/* properties should be used wherever possible.  A  */
/* bit-mask is defined for each bit-field.          */


/* First, some masks for the various class and      */
/* state fields.                                    */

#define ObjClAll                              0xfffflu
#define ObjStAll                          0xffff0000lu


/* Object class states - surrogate or active object */
#define ObjClStAll                            0x0003lu

#define ObjClStActive                         0x0001lu
#define ObjClStSurrogate                      0x0002lu


/* Object class types - The type of the object      */
/* e.g. certificate or cert request, revocation etc */
#define ObjClTypeAll                          0x00f0lu

#define ObjClTypeCert                         0x0010lu
#define ObjClTypeRev                          0x0020lu
#define ObjClTypeCrl                          0x0030lu


/* Flags */
#define ObjClFlagAll                          0xff00lu

/* Is the object modifiable at the JNH API          */
#define ObjFlagModifiable                     0x0100lu
/* Does the object need a password it proceed?      */
#define ObjFlagNeedsPassword                  0x0200lu
/* Has the object taken an error?                   */
#define ObjFlagError                          0x0400lu
/* Has the object taken a fatal error?              */
#define ObjFlagFatal                          0x0800lu

/* Now the specific states.  JNH callers should use */
/* these values only if there's no general property */
/* that will do.                                    */

#define ObjStEEGone                       0x00000000lu
#define ObjStEECertReqActive              0x00010000lu
#define ObjStEECertReqPopPendingS         0x00020000lu
#define ObjStEECertReqPopPending          0x00030000lu
#define ObjStEECertReqSubmittedS          0x00040000lu
#define ObjStEECertReqRejected            0x00050000lu
#define ObjStEECertIssued                 0x00060000lu

#define ObjStRAGone                       0x01000000lu
#define ObjStRAPrereqS                    0x01010000lu
#define ObjStRACertReqPending             0x01020000lu
#define ObjStRACertReqPopPendingS         0x01030000lu
#define ObjStRACertReqActive              0x01040000lu
#define ObjStRACertReqRAApproved          0x01050000lu
#define ObjStRACertReqWaitingForCAS       0x01060000lu
#define ObjStRACertReqRejecting           0x01070000lu
#define ObjStRACertCAApproved             0x01080000lu
#define ObjStRACertCARejected             0x01090000lu

#define ObjStCAGone                       0x02000000lu
#define ObjStCACertReqActive              0x02010000lu
#define ObjStCACertSigned                 0x02020000lu
#define ObjStCACertReqRejected            0x02030000lu




#endif
