/***************************************************************************
 * Copyright 1998 International Business Machines Corporation. All Rights
 * Reserved.
 *
 * Please read this carefully.  Your use of this reference implementation of
 * certain of the IETF public-key infrastructure specifications ("Software")
 * indicates your acceptance of the following.  If you do not agree to the
 * following, do not install or use any of the Software.
 *
 * Permission to use, reproduce, distribute and create derivative works from
 * the Software ("Software Derivative Works"), and to distribute such Software
 * Derivative Works is hereby granted to you by International Business
 * Machines Corporation ("IBM").  This permission includes a license under the
 * patents of IBM that are necessarily infringed by your use of the Software
 * as provided by IBM.
 *
 * IBM licenses the Software to you on an "AS IS" basis, without warranty of
 * any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL WARRANTIES OR CONDITIONS,
 * EITHER EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OR CONDITIONS OF MERCHANTABILITY, NON INFRINGEMENT AND FITNESS
 * FOR A PARTICULAR PURPOSE.  You are solely responsible for determining the
 * appropriateness of using this Software and assume all risks associated with
 * the use of this Software, including but not limited to the risks of program
 * errors, damage to or loss of data, programs or equipment, and
 * unavailability or interruption of operations.
 *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL,
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC CONSEQUENTIAL DAMAGES
 * (INCLUDING LOST PROFITS OR SAVINGS), EVEN IF IBM HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.  IBM will not be liable for the loss of, or
 * damage to, your records or data, or any damages claimed by you based on a
 * third party claim.
 *
 * IBM wishes to obtain your feedback to assist in improving the Software. You
 * grant IBM a world-wide, royalty-free right to use, copy, distribute,
 * sublicense and prepare derivative works based upon any feedback, including
 * materials, error corrections, Software Derivatives, enhancements,
 * suggestions and the like that you provide to IBM relating to the Software
 * (this does not include products for which you charge a royalty and
 * distribute to IBM under other terms and conditions).
 *
 * You agree to distribute the Software and any Software Derivatives under a
 * license agreement that: 1) is sufficient to notify all licensees of the
 * Software and Software Derivatives that IBM assumes no liability for any
 * claim that may arise regarding the Software or Software Derivatives, and 2)
 * that disclaims all warranties, both express and implied, from IBM regarding
 * the Software and Software Derivatives.  (If you include this Agreement with
 * any distribution of the Software or Software Derivatives you will have met
 * this requirement.)  You agree that you will not delete any copyright
 * notices in the Software.
 *
 * This Agreement is the exclusive statement of your rights in the Software as
 * provided by IBM.   Except for the rights granted to you in the second
 * paragraph above, You are not granted any other patent rights, including but
 * not limited to the right to make combinations of the Software with products
 * that infringe IBM patents. You agree to comply with all applicable laws and
 * regulations, including all export and import laws and regulation.  This
 * Agreement is governed by the laws of the State of New York.  This Agreement
 * supersedes all other communications, understandings or agreements we may
 * have had prior to this Agreement.
 ****************************************************************************/


#ifndef JONAHTP_H_
#define JONAHTP_H_

// {7E25D1E0-2658-11d2-99BD-0004ACE8485B}
static const CSSM_GUID JONAHTP_GUID = 
{ 0x7e25d1e0, 0x2658, 0x11d2, { 0x99, 0xbd, 0x0, 0x4, 0xac, 0xe8, 0x48, 0x5b } };

#define JONAHTP_MAJOR_VERSION	                      (1)
#define JONAHTP_MINOR_VERSION	                      (0)
#define JONAHTP_DESCRIPTION                          "Jonah PKIX Trust Policy Module"
#define JONAHTP_VENDOR                               "IBM Corporation"
#define JONAHTP_FLAGS                                CSSM_MODULE_THREADSAFE
#define JONAHTP_SERVICE_MASK                         CSSM_SERVICE_TP 
#define JONAHTP_NUMBER_OF_SERVICES                   (1)

#define JONAHTP_SERVICE_TYPE                         CSSM_SERVICE_TP
#define JONAHTP_SERVICE_FLAGS                        (0)
#define JONAHTP_NUMBER_OF_SUBSERVICES                (1)
#define JONAHTP_SUBSERVICE_ID                        (1)
#define JONAHTP_SUBSERVICE_DESCRIPTION               "PKIX Compliant Validation Engine"
#define JONAHTP_SUBSERVICE_CERTTYPE                  CSSM_CERT_X_509v3
#define JONAHTP_SUBSERVICE_AUTHENTICATIONMECHANISM   CSSM_AUTHENTICATION_NONE
#define JONAHTP_SUBSERVICE_NUMBEROFPOLICYIDENTIFIERS (1)

// use this OID as single supported PolicyIdentifiers.FieldOid to TP_certGroupVerify
#define JONAHTP_POLICY_OID_DATA                      0x06,0x06,0x2b,0x06,0x01,0x05,0x05,0x07
#define JONAHTP_POLICY_OID_LENGTH                    8

#endif   // JONAHTP_H_  







